/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.xu.plugin.internal;

import com.ibm.rules.res.xu.plugin.PluginException;
import ilog.rules.res.xu.event.IlrConnectionEvent;
import ilog.rules.res.xu.event.IlrConnectionEventListener;
import ilog.rules.res.xu.event.IlrRuleEngineEvent;
import ilog.rules.res.xu.event.IlrRuleEngineEventListener;
import ilog.rules.res.xu.event.internal.IlrXUEventDispatcher;
import ilog.rules.res.xu.plugin.internal.IlrAbstractPlugin;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class IlrDefaultPluginImpl
extends IlrAbstractPlugin
implements IlrRuleEngineEventListener,
IlrConnectionEventListener {
    protected EventFilter filter = new EventFilter(this);
    public static final String PROPERTY_KEY_RECEIVE_REINITIALIZATION_EVENTS = "receiveReinitializationEvents";

    @Override
    public void subscribe(IlrXUEventDispatcher eventDispatcher) {
        super.subscribe(eventDispatcher);
        eventDispatcher.addListener(this.filter, 512L);
        eventDispatcher.addListener(this.filter, 2048L);
    }

    @Override
    public void start() throws PluginException {
        String prop = this.properties.getProperty(PROPERTY_KEY_RECEIVE_REINITIALIZATION_EVENTS);
        this.filter.setReceiveReinitializationEvents(prop == null || !prop.equals("false"));
        super.start();
    }

    @Override
    public abstract void ruleEngineEventRaised(IlrRuleEngineEvent var1);

    @Override
    public abstract void connectionEventRaised(IlrConnectionEvent var1);

    public static class EventFilter
    implements IlrRuleEngineEventListener,
    IlrConnectionEventListener {
        protected boolean receiveReinitializationEvents = true;
        protected IlrDefaultPluginImpl listener;
        protected Set<Serializable> inReinitializationConnections = Collections.synchronizedSet(new HashSet());

        public EventFilter(IlrDefaultPluginImpl listener) {
            this.listener = listener;
        }

        public void setReceiveReinitializationEvents(boolean receiveReinitializationEvents) {
            this.receiveReinitializationEvents = receiveReinitializationEvents;
        }

        @Override
        public void ruleEngineEventRaised(IlrRuleEngineEvent event) {
            boolean forward = true;
            if (!this.receiveReinitializationEvents && event.getConnectionId() != null) {
                switch (event.getCode()) {
                    case 24: {
                        this.inReinitializationConnections.add(event.getConnectionId());
                        break;
                    }
                    case 25: {
                        this.inReinitializationConnections.remove(event.getConnectionId());
                        break;
                    }
                    default: {
                        if (!this.inReinitializationConnections.contains(event.getConnectionId())) break;
                        forward = false;
                    }
                }
            }
            if (forward) {
                this.listener.ruleEngineEventRaised(event);
            }
        }

        @Override
        public void connectionEventRaised(IlrConnectionEvent event) {
            if (!this.receiveReinitializationEvents && event.getCode() == 1) {
                this.inReinitializationConnections.remove(event.getConnectionId());
            }
            this.listener.connectionEventRaised(event);
        }
    }
}

