/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.xu.plugin.internal;

import com.ibm.rules.res.logging.internal.XUSourceLogRecord;
import com.ibm.rules.res.message.internal.XUMessageCode;
import com.ibm.rules.res.util.internal.PropertiesConverter;
import com.ibm.rules.res.xu.client.internal.ChannelMessage;
import com.ibm.rules.res.xu.config.internal.PluginConfig;
import com.ibm.rules.res.xu.config.internal.XUConfig;
import com.ibm.rules.res.xu.engine.internal.AuthorizationProvider;
import com.ibm.rules.res.xu.engine.internal.ChannelMessageListener;
import com.ibm.rules.res.xu.engine.internal.EngineListener;
import com.ibm.rules.res.xu.engine.internal.EngineManager;
import com.ibm.rules.res.xu.engine.internal.EngineManagerListener;
import com.ibm.rules.res.xu.event.ConnectionEvent;
import com.ibm.rules.res.xu.event.RuleEvent;
import com.ibm.rules.res.xu.event.RulesetArchiveEvent;
import com.ibm.rules.res.xu.event.TaskEvent;
import com.ibm.rules.res.xu.event.internal.XUListener;
import com.ibm.rules.res.xu.log.internal.LogHandler;
import com.ibm.rules.res.xu.log.internal.LogListener;
import com.ibm.rules.res.xu.plugin.Plugin;
import com.ibm.rules.res.xu.plugin.PluginException;
import com.ibm.rules.res.xu.plugin.internal.AuthorizationPlugin;
import com.ibm.rules.res.xu.spi.internal.XUResourceAdapter;
import ilog.rules.res.xu.cci.IlrInteractionExtension;
import ilog.rules.res.xu.cci.IlrXUConnectionFactory;
import ilog.rules.res.xu.event.internal.IlrXUEventDispatcher;
import ilog.rules.res.xu.plugin.internal.IlrPlugin;
import ilog.rules.res.xu.ruleset.internal.IlrRulesetUsageInformationMonitorImpl;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public final class IlrPluginManager
implements EngineManagerListener,
ChannelMessageListener,
EngineListener,
LogListener,
XUListener,
XUResourceAdapter.Listener {
    protected List<PluginConfig> pluginConfigs = new ArrayList<PluginConfig>();
    protected IlrXUEventDispatcher xuEventDispatcher = null;
    protected LogHandler logger = null;
    protected transient WeakReference<IlrXUConnectionFactory> connectionFactoryReference = null;
    protected transient XUConfig xuConfig;
    protected transient ArrayList<IlrPlugin> plugins = new ArrayList();
    protected transient AuthorizationProvider authProvider;
    protected transient EngineManagerListener[] engineManagerListeners;
    private transient boolean started = false;
    protected transient IlrInteractionExtension[] interactionExtensions = null;
    protected transient XUResourceAdapter adapter;
    protected transient IlrRulesetUsageInformationMonitorImpl rulesetUsageMonitor;

    public IlrPluginManager(LogHandler logHandler, IlrXUEventDispatcher xuEventDispatcher) {
        this.xuEventDispatcher = xuEventDispatcher;
        this.logger = logHandler;
        this.logger.addListener(this);
    }

    public List<PluginConfig> getPluginConfigs() {
        return this.pluginConfigs;
    }

    public synchronized void setConnectionFactory(IlrXUConnectionFactory connectionFactory) {
        this.connectionFactoryReference = new WeakReference<IlrXUConnectionFactory>(connectionFactory);
        for (IlrPlugin p : this.plugins) {
            p.setConnectionFactory(connectionFactory);
        }
    }

    public synchronized void setXUConfig(XUConfig xuConfig) {
        this.logger.log(new XUSourceLogRecord.Entry(xuConfig));
        this.xuConfig = xuConfig;
        for (IlrPlugin p : this.plugins) {
            p.setXUConfig(xuConfig);
        }
        this.logger.log(new XUSourceLogRecord.Exit());
    }

    public synchronized IlrInteractionExtension[] getInteractionExtensions() {
        if (!this.started) {
            return new IlrInteractionExtension[0];
        }
        if (this.interactionExtensions == null) {
            Iterator<IlrPlugin> iterator = this.plugins.iterator();
            ArrayList<IlrInteractionExtension> extensions = new ArrayList<IlrInteractionExtension>();
            while (iterator.hasNext()) {
                IlrPlugin plugin = iterator.next();
                IlrInteractionExtension extension = plugin.getInteractionExtension();
                if (extension == null) continue;
                extensions.add(extension);
            }
            this.interactionExtensions = extensions.toArray(new IlrInteractionExtension[extensions.size()]);
        }
        return this.interactionExtensions;
    }

    public void update(List<PluginConfig> pluginsProperty) {
        this.logger.log(new XUSourceLogRecord.Entry(pluginsProperty));
        if (((Object)pluginsProperty).equals(this.pluginConfigs)) {
            return;
        }
        this.pluginConfigs = pluginsProperty;
        if (this.started) {
            try {
                this.changePlugins();
                this.startPlugins();
            }
            catch (PluginException e) {
                this.logger.severe("XU.ERROR.10046", e, null, null);
            }
        }
        this.logger.log(new XUSourceLogRecord.Exit());
    }

    private void changePlugins() throws PluginException {
        this.destroyPlugins();
        this.createPlugins(this.pluginConfigs);
    }

    private void createPlugins(List<PluginConfig> list) throws PluginException {
        IlrInteractionExtension extension;
        int nb = list.size();
        ArrayList<IlrPlugin> newPlugins = new ArrayList<IlrPlugin>();
        for (int i = 0; i < nb; ++i) {
            Map<String, String> props = list.get(i).getProperties();
            try {
                IlrPlugin plugin = this.createPlugin(props);
                newPlugins.add(plugin);
                continue;
            }
            catch (PluginException e) {
                this.logger.severe("XU.ERROR.10046", e, null, null);
            }
        }
        for (IlrPlugin plugin : newPlugins) {
            extension = plugin.getInteractionExtension();
            if (extension == null || extension.getSupportedFunctionNames() != null) continue;
            this.logger.warning(XUMessageCode.WARNING_PLUGIN_GET_SUPPORTED_FUNCTION_NAMES_NOT_DEFINED, null, new String[]{plugin.getClass().getName()}, plugin, null, true);
        }
        HashSet<String> allNames = new HashSet<String>();
        for (IlrPlugin plugin : newPlugins) {
            String[] fctNames;
            extension = plugin.getInteractionExtension();
            if (extension == null || extension.getSupportedFunctionNames() == null) continue;
            for (String fctName : fctNames = extension.getSupportedFunctionNames()) {
                if (allNames.contains(fctName)) {
                    String pClass = plugin.getClass().getName();
                    PluginException exception = new PluginException("XU.ERROR.15000", (Object[])new String[]{pClass, fctName}, null);
                    throw exception;
                }
                allNames.add(fctName);
            }
        }
        this.plugins = newPlugins;
    }

    private static final String getClassName(Map<String, String> properties) {
        String prop = properties.get("pluginClass");
        if (prop != null) {
            if (prop.equals("HTDS")) {
                return "com.ibm.rules.htds.plugin.cci.internal.DLGeneratorPlugin";
            }
            if (prop.equals("DVS")) {
                return "com.ibm.rules.dvs.plugin.cci.internal.ExecutionTracePlugin";
            }
            if (prop.equals("Management")) {
                return "com.ibm.rules.res.xu.management.XUManagementPlugin";
            }
            if (prop.equals("Monitoring")) {
                return "com.ibm.rules.res.xu.management.XUMonitoringPlugin";
            }
            if (prop.equals("Event")) {
                return "com.ibm.rules.res.event.plugin.EventPlugin";
            }
            if (prop.equals("SMF")) {
                return "com.ibm.rules.hbr.smf.SMFPlugin";
            }
        }
        return prop;
    }

    private IlrPlugin createPlugin(Map<String, String> properties) throws PluginException {
        this.logger.info("XU.INFO.8004", new Object[]{properties});
        String className = IlrPluginManager.getClassName(properties);
        if (className == null) {
            throw new PluginException("XU.ERROR.10019", (Object[])new String[]{properties.toString()}, null);
        }
        try {
            Class<?> clazz = Class.forName(className);
            IlrPlugin plugin = (IlrPlugin)clazz.newInstance();
            plugin.setLogHandler(this.logger);
            plugin.setProperties(PropertiesConverter.toProperties(properties));
            if (this.connectionFactoryReference != null) {
                plugin.setConnectionFactory((IlrXUConnectionFactory)this.connectionFactoryReference.get());
            }
            if (this.xuConfig != null) {
                plugin.setXUConfig(this.xuConfig);
            }
            return plugin;
        }
        catch (Throwable e) {
            throw new PluginException("XU.ERROR.10022", (Object[])new String[]{properties.toString()}, e);
        }
    }

    protected void startPlugins() {
        this.logger.log(new XUSourceLogRecord.Entry(new Object[0]));
        if (this.adapter != null) {
            this.logger.log(new XUSourceLogRecord(Level.FINEST, "workManager=" + this.adapter.getWorkManager(), new Object[0]));
        }
        this.authProvider = null;
        ArrayList<EngineManagerListener> listeners = new ArrayList<EngineManagerListener>();
        for (IlrPlugin plugin : this.plugins) {
            this.logger.info("XU.INFO.8005", new Object[]{plugin});
            try {
                plugin.setRulesetUsageInformationMonitor(this.rulesetUsageMonitor);
                plugin.setResourceAdapter(this.adapter);
                plugin.start();
                if (!(plugin instanceof Plugin)) {
                    plugin.subscribe(this.xuEventDispatcher);
                }
                if (plugin instanceof EngineManagerListener) {
                    listeners.add((EngineManagerListener)((Object)plugin));
                }
                if (!(plugin instanceof AuthorizationPlugin)) continue;
                this.authProvider = (AuthorizationPlugin)plugin;
            }
            catch (Throwable e) {
                this.logger.severe("XU.ERROR.10020", e, new Object[]{plugin}, null);
            }
        }
        if (listeners.size() > 0) {
            this.engineManagerListeners = new EngineManagerListener[listeners.size()];
            int i = 0;
            for (EngineManagerListener l : listeners) {
                this.engineManagerListeners[i++] = l;
            }
        } else {
            this.engineManagerListeners = null;
        }
    }

    public final void destroyPlugins() {
        this.logger.log(new XUSourceLogRecord.Entry(new Object[0]));
        for (IlrPlugin plugin : this.plugins) {
            this.logger.info("XU.INFO.8006", new Object[]{plugin});
            try {
                if (!(plugin instanceof Plugin)) {
                    plugin.unsubscribe(this.xuEventDispatcher);
                }
                this.logger.log(new XUSourceLogRecord(Level.FINEST, "destroy " + plugin, new Object[0]));
                plugin.destroy();
                this.engineManagerListeners = null;
            }
            catch (Throwable e) {
                this.logger.severe("XU.ERROR.10021", e, new Object[]{plugin}, null);
            }
        }
        this.plugins = new ArrayList();
        this.logger.log(new XUSourceLogRecord.Exit());
    }

    @Override
    public void destroyPerformed(EngineManager engineManager) {
        if (this.engineManagerListeners != null) {
            int n = this.engineManagerListeners.length;
            for (int i = 0; i < n; ++i) {
                this.engineManagerListeners[i].destroyPerformed(engineManager);
            }
        }
    }

    @Override
    public void cleanupPerformed(EngineManager engineManager) {
        if (this.engineManagerListeners != null) {
            int n = this.engineManagerListeners.length;
            for (int i = 0; i < n; ++i) {
                this.engineManagerListeners[i].cleanupPerformed(engineManager);
            }
        }
    }

    @Override
    public void startPerformed(EngineManager engineManager) {
        if (this.engineManagerListeners != null) {
            int n = this.engineManagerListeners.length;
            for (int i = 0; i < n; ++i) {
                this.engineManagerListeners[i].startPerformed(engineManager);
            }
        }
    }

    @Override
    public void executeEnded(EngineManager engineManager, long duration) {
        if (this.engineManagerListeners != null) {
            int n = this.engineManagerListeners.length;
            for (int i = 0; i < n; ++i) {
                this.engineManagerListeners[i].executeEnded(engineManager, duration);
            }
        }
    }

    @Override
    public void setParametersPerformed(EngineManager engineManager, long duration) {
        if (this.engineManagerListeners != null) {
            int n = this.engineManagerListeners.length;
            for (int i = 0; i < n; ++i) {
                this.engineManagerListeners[i].setParametersPerformed(engineManager, duration);
            }
        }
    }

    @Override
    public void getParametersPerformed(EngineManager engineManager, long duration) {
        if (this.engineManagerListeners != null) {
            int n = this.engineManagerListeners.length;
            for (int i = 0; i < n; ++i) {
                this.engineManagerListeners[i].getParametersPerformed(engineManager, duration);
            }
        }
    }

    @Override
    public void executeStarted(EngineManager engineManager) {
        if (this.engineManagerListeners != null) {
            int n = this.engineManagerListeners.length;
            for (int i = 0; i < n; ++i) {
                this.engineManagerListeners[i].executeStarted(engineManager);
            }
        }
    }

    @Override
    public void executeFailed(EngineManager engineManager, long duration) {
        if (this.engineManagerListeners != null) {
            int n = this.engineManagerListeners.length;
            for (int i = 0; i < n; ++i) {
                this.engineManagerListeners[i].executeFailed(engineManager, duration);
            }
        }
    }

    @Override
    public void executeTaskStarted(String task, EngineManager engineManager) {
        if (this.engineManagerListeners != null) {
            int n = this.engineManagerListeners.length;
            for (int i = 0; i < n; ++i) {
                this.engineManagerListeners[i].executeTaskStarted(task, engineManager);
            }
        }
    }

    @Override
    public void executeTaskEnded(String task, EngineManager engineManager, long duration) {
        if (this.engineManagerListeners != null) {
            int n = this.engineManagerListeners.length;
            for (int i = 0; i < n; ++i) {
                this.engineManagerListeners[i].executeTaskEnded(task, engineManager, duration);
            }
        }
    }

    @Override
    public void executeTaskFailed(String task, EngineManager engineManager, long duration) {
        if (this.engineManagerListeners != null) {
            int n = this.engineManagerListeners.length;
            for (int i = 0; i < n; ++i) {
                this.engineManagerListeners[i].executeTaskFailed(task, engineManager, duration);
            }
        }
    }

    @Override
    public void channelMessageEmitted(EngineManager engine, ChannelMessage msg) {
        for (IlrPlugin plugin : this.plugins) {
            if (!(plugin instanceof ChannelMessageListener)) continue;
            ChannelMessageListener l = (ChannelMessageListener)((Object)plugin);
            l.channelMessageEmitted(engine, msg);
        }
    }

    @Override
    public void taskCompleted(TaskEvent evt) {
        for (IlrPlugin plugin : this.plugins) {
            if (!(plugin instanceof EngineListener)) continue;
            ((EngineListener)((Object)plugin)).taskCompleted(evt);
        }
    }

    @Override
    public void taskStarted(TaskEvent evt) {
        for (IlrPlugin plugin : this.plugins) {
            if (!(plugin instanceof EngineListener)) continue;
            ((EngineListener)((Object)plugin)).taskStarted(evt);
        }
    }

    @Override
    public void ruleExecutionCompleted(RuleEvent evt) {
        for (IlrPlugin plugin : this.plugins) {
            if (!(plugin instanceof EngineListener)) continue;
            ((EngineListener)((Object)plugin)).ruleExecutionCompleted(evt);
        }
    }

    @Override
    public void ruleExecutionStarted(RuleEvent evt) {
        for (IlrPlugin plugin : this.plugins) {
            if (!(plugin instanceof EngineListener)) continue;
            ((EngineListener)((Object)plugin)).ruleExecutionStarted(evt);
        }
    }

    public void setRulesetUsageMonitor(IlrRulesetUsageInformationMonitorImpl monitor) {
        this.rulesetUsageMonitor = monitor;
        for (IlrPlugin plugin : this.plugins) {
            plugin.setRulesetUsageInformationMonitor(monitor);
        }
    }

    @Override
    public void connectionOpened(ConnectionEvent evt) {
        for (IlrPlugin plugin : this.plugins) {
            if (!(plugin instanceof XUListener)) continue;
            ((XUListener)((Object)plugin)).connectionOpened(evt);
        }
    }

    @Override
    public void connectionClosed(ConnectionEvent evt) {
        for (IlrPlugin plugin : this.plugins) {
            if (!(plugin instanceof XUListener)) continue;
            ((XUListener)((Object)plugin)).connectionClosed(evt);
        }
    }

    @Override
    public void rulesetArchiveChanged(RulesetArchiveEvent evt) {
        for (IlrPlugin plugin : this.plugins) {
            if (!(plugin instanceof XUListener)) continue;
            ((XUListener)((Object)plugin)).rulesetArchiveChanged(evt);
        }
    }

    @Override
    public void recordLogged(LogRecord rec) {
        for (IlrPlugin plugin : this.plugins) {
            if (!(plugin instanceof LogListener)) continue;
            ((LogListener)((Object)plugin)).recordLogged(rec);
        }
    }

    public AuthorizationProvider getAuthorizationProvider() {
        return this.authProvider;
    }

    @Override
    public void resourceAdapterStarted(XUResourceAdapter adapter) {
        this.logger.log(new XUSourceLogRecord.Entry(adapter));
        this.logger.log(new XUSourceLogRecord(Level.FINEST, "workmanager=", adapter.getWorkManager()));
        this.adapter = adapter;
        try {
            this.started = true;
            this.changePlugins();
            this.startPlugins();
        }
        catch (PluginException e) {
            this.logger.severe("XU.ERROR.10046", e, null, null);
        }
        this.logger.log(new XUSourceLogRecord.Exit());
    }

    public boolean isStarted() {
        return this.started;
    }

    @Override
    public final void resourceAdapterStopped(XUResourceAdapter adapter) {
        this.logger.log(new XUSourceLogRecord.Entry(adapter));
        this.destroyPlugins();
        this.logger.log(new XUSourceLogRecord.Exit());
    }
}

