/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.xu.ruleset.cache.internal;

import com.ibm.rules.res.logging.internal.XUSourceLogRecord;
import com.ibm.rules.res.xu.engine.xml.internal.XMLObjectService;
import com.ibm.rules.res.xu.info.internal.XUInfoImpl;
import com.ibm.rules.res.xu.internal.XUException;
import com.ibm.rules.res.xu.ruleset.internal.XURulesetImpl;
import com.ibm.rules.res.xu.work.internal.PeriodicWorkManager;
import ilog.rules.res.model.IlrEngineType;
import ilog.rules.res.model.IlrRulesetArchiveProperties;
import ilog.rules.res.xu.ruleset.IlrRulesetCache;
import ilog.rules.res.xu.ruleset.IlrRulesetCacheException;
import ilog.rules.res.xu.ruleset.IlrRulesetUsageInformation;
import ilog.rules.res.xu.ruleset.IlrRulesetUsageInformationMonitor;
import ilog.rules.res.xu.ruleset.IlrXURuleset;
import ilog.rules.res.xu.ruleset.cache.internal.IlrMaintenanceTask;
import ilog.rules.res.xu.ruleset.cache.internal.IlrRulesetCacheEntry;
import ilog.rules.res.xu.ruleset.cache.internal.IlrStrongReference;
import ilog.rules.res.xu.ruleset.cache.internal.IlrWeakReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IlrRulesetCacheImpl
implements IlrRulesetCache {
    public static final String KEY_MAINTENANCE_PERIOD = "ruleset.cache.maintenance.period";
    public static final String KEY_CLASS = "ruleset.cache.class";
    public static final long DEFAULT_MAINTENANCE_PERIOD = 0L;
    protected transient List<IlrRulesetCacheEntry> entries = new ArrayList<IlrRulesetCacheEntry>();
    protected transient List<IlrRulesetCacheEntry> oldEntries = new ArrayList<IlrRulesetCacheEntry>();
    private transient Logger log = null;
    private transient Object syncObject = this.entries;
    protected IlrRulesetUsageInformationMonitor rulesetUsageMonitor;
    private boolean maxIdleTimeOutSupport = false;
    private PeriodicWorkManager periodicWorkMgr;
    private boolean isFinestLoggable = false;

    public IlrRulesetUsageInformationMonitor getRulesetUsageInformationMonitor() {
        return this.rulesetUsageMonitor;
    }

    @Override
    public void initialize(Logger logger, Map<String, String> props, IlrRulesetUsageInformationMonitor monitor) throws IlrRulesetCacheException {
        String maintenancePeriodStr;
        this.log = logger;
        this.isFinestLoggable = logger.isLoggable(Level.FINEST);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(new XUSourceLogRecord.Entry(props, monitor));
        }
        this.rulesetUsageMonitor = monitor;
        if (this.isFinestLoggable) {
            logger.log(new XUSourceLogRecord(Level.FINEST, "rulesetUsageMonitor available: " + (this.rulesetUsageMonitor != null), new Object[0]));
        }
        if (props != null && (maintenancePeriodStr = props.get(KEY_MAINTENANCE_PERIOD)) != null) {
            try {
                Long maintenancePeriodMs = 1000L * Long.parseLong(maintenancePeriodStr);
                if (maintenancePeriodMs > 0L) {
                    this.periodicWorkMgr.schedule(maintenancePeriodMs, new IlrMaintenanceTask(this, logger));
                    if (this.isFinestLoggable) {
                        logger.log(new XUSourceLogRecord(Level.FINEST, "period=" + maintenancePeriodMs, new Object[0]));
                    }
                    if (this.rulesetUsageMonitor != null) {
                        this.maxIdleTimeOutSupport = true;
                    }
                }
            }
            catch (NumberFormatException e) {
                throw new IlrRulesetCacheException("XU.ERROR.16000", (String[])null, (Throwable)e);
            }
            catch (XUException e) {
                throw new IlrRulesetCacheException("XU.ERROR.16000", (String[])null, (Throwable)e);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(new XUSourceLogRecord.Exit());
        }
    }

    @Override
    public IlrXURuleset getRuleset(String canonicalRulesetPath, ClassLoader xomClassLoader) {
        if (this.log.isLoggable(Level.FINER)) {
            this.log.log(new XUSourceLogRecord.Entry(new Object[]{canonicalRulesetPath, xomClassLoader}));
        }
        IlrXURuleset r = this.getRuleset(canonicalRulesetPath, xomClassLoader, this.entries);
        if (this.log.isLoggable(Level.FINER)) {
            this.log.log(new XUSourceLogRecord.Exit(r));
        }
        return r;
    }

    @Override
    public IlrXURuleset getDeprecatedRuleset(String canonicalRulesetPath, ClassLoader xomClassLoader) {
        return this.getRuleset(canonicalRulesetPath, xomClassLoader, this.oldEntries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRuleset(IlrXURuleset executableRuleset) {
        Object object = this.syncObject;
        synchronized (object) {
            if (this.log.isLoggable(Level.FINER)) {
                this.log.log(new XUSourceLogRecord.Entry(executableRuleset));
            }
            if (this.isFinestLoggable) {
                this.log.log(new XUSourceLogRecord(Level.FINEST, "canonical path=" + executableRuleset.getCanonicalRulesetPath(), new Object[0]));
                this.log.log(new XUSourceLogRecord(Level.FINEST, "caches before ruleset addition:", new Object[0]));
            }
            this.logAllCaches();
            this.entries.add(new IlrRulesetCacheEntry(executableRuleset, this.maxIdleTimeOutSupport));
            if (this.isFinestLoggable) {
                this.log.log(new XUSourceLogRecord(Level.FINEST, "caches after ruleset addition:", new Object[0]));
            }
            this.logAllCaches();
            if (this.log.isLoggable(Level.FINER)) {
                this.log.log(new XUSourceLogRecord.Exit(executableRuleset));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.syncObject;
        synchronized (object) {
            this.entries.clear();
            this.oldEntries.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rulesetChanged(String canonicalRulesetPath) {
        if (this.log.isLoggable(Level.FINER)) {
            this.log.log(new XUSourceLogRecord.Entry(canonicalRulesetPath));
        }
        Object object = this.syncObject;
        synchronized (object) {
            IlrXURuleset ruleset;
            IlrRulesetCacheEntry entry;
            this.logAllCaches();
            Iterator<IlrRulesetCacheEntry> iterator = this.entries.iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                ruleset = entry.rulesetReference.get();
                if (ruleset == null) {
                    if (this.isFinestLoggable) {
                        this.logFinest(".rulesetChanged: removing from the cache: " + entry.canonicalRulesetPath, false);
                    }
                    iterator.remove();
                    continue;
                }
                if (!entry.canonicalRulesetPath.equals(canonicalRulesetPath)) continue;
                if (this.isFinestLoggable) {
                    this.logFinest(".rulesetChanged: removing from the cache: " + entry.canonicalRulesetPath, false);
                }
                iterator.remove();
                if (entry.rulesetReference instanceof IlrStrongReference) {
                    entry.rulesetReference = new IlrWeakReference<IlrXURuleset>(ruleset);
                }
                this.oldEntries.add(0, entry);
            }
            iterator = this.oldEntries.iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                ruleset = entry.rulesetReference.get();
                if (ruleset != null) continue;
                iterator.remove();
            }
        }
        if (this.isFinestLoggable) {
            this.logFinest(".rulesetChanged: end changePerformed", false);
        }
        this.logAllCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logAllCaches() {
        if (this.log == null || !this.isFinestLoggable) {
            return;
        }
        Object object = this.syncObject;
        synchronized (object) {
            this.logFinest(".logAllCaches: ruleset cache: size: " + this.entries.size(), false);
            this.logCache(this.entries);
            this.logFinest(".logAllCaches: Deprecated Ruleset cache: size: ", false);
            this.logCache(this.oldEntries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logCache(List<IlrRulesetCacheEntry> cache) {
        if (this.log == null || !this.isFinestLoggable) {
            return;
        }
        Object object = this.syncObject;
        synchronized (object) {
            int i = 0;
            for (IlrRulesetCacheEntry entry : cache) {
                this.logFinest(".logCache: entry n." + i + ": path:" + entry.canonicalRulesetPath + " ruleset: " + entry.rulesetReference.get() + " " + entry.rulesetReference.getClass() + " " + entry.xomClassLoader, false);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(XUInfoImpl dump) {
        Object object = this.syncObject;
        synchronized (object) {
            boolean isDE;
            IlrRulesetArchiveProperties props;
            int poolSize;
            XMLObjectService service;
            int reserveTimeout;
            int poolMaxSize;
            IlrXURuleset ruleset;
            for (IlrRulesetCacheEntry entry : this.entries) {
                ruleset = entry.rulesetReference.get();
                poolMaxSize = -1;
                reserveTimeout = -1;
                if (ruleset != null) {
                    service = ((XURulesetImpl)ruleset).getXMLObjectService();
                    poolSize = service.getXMLDocumentDriverPoolSize();
                    props = ruleset.getRulesetArchiveProperties();
                    isDE = props.getEngineType() == IlrEngineType.DE;
                } else {
                    service = null;
                    isDE = false;
                    poolSize = -1;
                }
                dump.addRulesetCacheEntry(entry.canonicalRulesetPath, ruleset, entry.rulesetReference instanceof WeakReference, poolSize, poolMaxSize, reserveTimeout, isDE);
            }
            for (IlrRulesetCacheEntry entry : this.oldEntries) {
                ruleset = entry.rulesetReference.get();
                poolMaxSize = -1;
                reserveTimeout = -1;
                if (ruleset != null) {
                    service = ((XURulesetImpl)ruleset).getXMLObjectService();
                    poolSize = service.getXMLDocumentDriverPoolSize();
                    props = ruleset.getRulesetArchiveProperties();
                    isDE = props.getEngineType() == IlrEngineType.DE;
                } else {
                    service = null;
                    isDE = false;
                    poolSize = -1;
                }
                dump.addDeprecatedRulesetCacheEntry(entry.canonicalRulesetPath, ruleset, entry.rulesetReference instanceof WeakReference, poolSize, poolMaxSize, reserveTimeout, isDE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IlrXURuleset getRuleset(String canonicalRulesetPath, ClassLoader xomClassLoader, List<IlrRulesetCacheEntry> cache) {
        boolean isFinerLoggable = this.log.isLoggable(Level.FINER);
        if (isFinerLoggable) {
            this.log.log(new XUSourceLogRecord.Entry(new Object[]{canonicalRulesetPath, xomClassLoader, cache}));
        }
        Object object = this.syncObject;
        synchronized (object) {
            this.logAllCaches();
            Iterator<IlrRulesetCacheEntry> iterator = cache.iterator();
            while (iterator.hasNext()) {
                IlrRulesetCacheEntry entry = iterator.next();
                IlrXURuleset ruleset = entry.rulesetReference.get();
                if (ruleset == null) {
                    if (this.isFinestLoggable) {
                        this.log.log(new XUSourceLogRecord(Level.FINEST, "remove ruleset from cache", entry.canonicalRulesetPath));
                    }
                    iterator.remove();
                    continue;
                }
                if (!entry.canonicalRulesetPath.equals(canonicalRulesetPath) || entry.xomClassLoader != xomClassLoader && (entry.xomClassLoader == null || entry.xomClassLoader.getParent() != xomClassLoader)) continue;
                if (isFinerLoggable) {
                    this.log.log(new XUSourceLogRecord.Exit(ruleset));
                }
                return ruleset;
            }
        }
        if (this.isFinestLoggable) {
            this.log.log(new XUSourceLogRecord(Level.FINEST, "cache miss", canonicalRulesetPath));
        }
        if (isFinerLoggable) {
            this.log.log(new XUSourceLogRecord.Exit());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runMaintenanceTask() {
        if (this.isFinestLoggable) {
            this.logFinest(".runMaintenanceTask: run maintenance task at: " + System.currentTimeMillis(), true);
        }
        if (this.rulesetUsageMonitor == null) {
            if (this.isFinestLoggable) {
                this.logFinest(".runMaintenanceTask: no RulesetUsageMonitor", true);
            }
            return;
        }
        List<IlrRulesetCacheEntry> list = this.entries;
        synchronized (list) {
            Iterator<IlrRulesetCacheEntry> iterator = this.entries.iterator();
            while (iterator.hasNext()) {
                boolean isTimeoutReached;
                IlrRulesetCacheEntry entry = iterator.next();
                IlrXURuleset ruleset = entry.rulesetReference.get();
                if (ruleset == null) {
                    if (this.isFinestLoggable) {
                        this.logFinest(".runMaintenanceTask: remove garbaged ruleset", true);
                    }
                    iterator.remove();
                    continue;
                }
                String path = ruleset.getCanonicalRulesetPath();
                long maxIdleTimeS = ruleset.getRulesetArchiveProperties().getMaxIdleTime();
                if (maxIdleTimeS == -1L || maxIdleTimeS == 0L) continue;
                long maxIdleTime = maxIdleTimeS * 1000L;
                IlrRulesetUsageInformation info = this.rulesetUsageMonitor.getRulesetUsageInformation(path);
                boolean isIdle = info.isIdle();
                long lastUsageTime = info.getLastUsageTime();
                boolean bl = isTimeoutReached = maxIdleTime < System.currentTimeMillis() - lastUsageTime;
                if (!isIdle || !isTimeoutReached) {
                    if (this.isFinestLoggable) {
                        this.logFinest(".runMaintenanceTask: ruleset " + path + " is not idle or used before timeout", true);
                    }
                    if (!(entry.rulesetReference instanceof IlrWeakReference)) continue;
                    entry.rulesetReference = new IlrStrongReference<IlrXURuleset>(ruleset);
                    continue;
                }
                if (this.isFinestLoggable) {
                    this.logFinest(".runMaintenanceTask: ruleset " + path + " is idle", true);
                }
                if (!isTimeoutReached) continue;
                if (this.isFinestLoggable) {
                    this.logFinest(".runMaintenanceTask: ruleset " + path + " has exceed the max idle time", true);
                }
                entry.rulesetReference = new IlrWeakReference<IlrXURuleset>(ruleset);
            }
        }
    }

    private void logFinest(String message, boolean flush) {
        if (this.log != null && this.isFinestLoggable) {
            this.log.log(new XUSourceLogRecord(Level.FINEST, message, new Object[0]));
            if (flush) {
                for (Handler handler : this.log.getHandlers()) {
                    handler.flush();
                }
            }
        }
    }

    public final void setPeriodicWorkManager(PeriodicWorkManager mgr) {
        this.periodicWorkMgr = mgr;
    }
}

