/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.xu.ruleset.internal;

import com.ibm.rules.res.logging.internal.XUSourceLogRecord;
import com.ibm.rules.res.xu.engine.internal.EngineManager;
import com.ibm.rules.res.xu.engine.internal.EngineManagerListener;
import com.ibm.rules.res.xu.info.internal.XUInfoImpl;
import com.ibm.rules.res.xu.log.internal.LogHandler;
import com.ibm.rules.res.xu.ruleset.internal.XURulesetFactoryListener;
import ilog.rules.res.mprofiler.IlrMemoryInstrumentation;
import ilog.rules.res.mprofiler.IlrProfilerException;
import ilog.rules.res.xu.ruleset.IlrRulesetUsageInformation;
import ilog.rules.res.xu.ruleset.IlrRulesetUsageInformationMonitor;
import ilog.rules.res.xu.ruleset.internal.IlrRulesetUsageInformationImpl;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public final class IlrRulesetUsageInformationMonitorImpl
implements IlrRulesetUsageInformationMonitor,
EngineManagerListener,
XURulesetFactoryListener,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient Map<String, Set<EngineManager>> rulesetUsage = new HashMap<String, Set<EngineManager>>();
    private final LogHandler logger;
    private final Map<String, Long> lastTimeUsage = new HashMap<String, Long>();
    private final Map<String, IlrRulesetUsageInformationImpl> rulesetsInformation = new HashMap<String, IlrRulesetUsageInformationImpl>();
    private boolean isFinestLoggable;
    private boolean isFinerLoggable;

    public IlrRulesetUsageInformationMonitorImpl(LogHandler logger) {
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(XUInfoImpl dump) {
        Map<String, IlrRulesetUsageInformationImpl> map = this.rulesetsInformation;
        synchronized (map) {
            for (Map.Entry<String, IlrRulesetUsageInformationImpl> entry : this.rulesetsInformation.entrySet()) {
                dump.addRulesetUsageInformation(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getLastTimeUsage(String canonicalRPath) {
        Set<EngineManager> engines = this.getEngines(canonicalRPath);
        if (engines != null) {
            for (EngineManager engineManager : engines) {
                if (engineManager.getState() != 2) continue;
                return 0L;
            }
        }
        IlrRulesetUsageInformationMonitorImpl ilrRulesetUsageInformationMonitorImpl = this;
        synchronized (ilrRulesetUsageInformationMonitorImpl) {
            Long time = this.lastTimeUsage.get(canonicalRPath);
            if (time == null) {
                return -1L;
            }
            return time;
        }
    }

    private synchronized Set<EngineManager> getEngines(String canonicalRPath) {
        Set<EngineManager> engines = this.rulesetUsage.get(canonicalRPath);
        if (engines == null) {
            return null;
        }
        HashSet<EngineManager> enginesCpy = new HashSet<EngineManager>(engines.size());
        enginesCpy.addAll(engines);
        return enginesCpy;
    }

    boolean isIdle(String canonicalRPath) {
        if (this.isFinerLoggable) {
            this.logger.log(new XUSourceLogRecord.Entry(canonicalRPath));
        }
        Set<EngineManager> engines = this.getEngines(canonicalRPath);
        if (this.isFinestLoggable) {
            this.logger.log(new XUSourceLogRecord(Level.FINEST, "engines=" + engines, new Object[0]));
        }
        boolean result = true;
        if (engines != null) {
            for (EngineManager e : engines) {
                if (e.getState() != 2) continue;
                result = false;
            }
        }
        if (this.isFinestLoggable) {
            this.logger.log(new XUSourceLogRecord.Exit(result));
        }
        return result;
    }

    @Override
    public synchronized void cleanupPerformed(EngineManager engineManager) {
        String canonicalRulesetPath = this.getCanonicalRulesetPath(engineManager);
        if (this.isFinestLoggable) {
            this.logger.log(new XUSourceLogRecord(Level.FINEST, "path=" + canonicalRulesetPath, new Object[0]));
        }
        this.lastTimeUsage.put(canonicalRulesetPath, System.currentTimeMillis());
    }

    @Override
    public synchronized void destroyPerformed(EngineManager engineManager) {
        Set<EngineManager> engineManagers;
        String canonicalRulesetPath = this.getCanonicalRulesetPath(engineManager);
        if (this.isFinestLoggable) {
            this.logger.log(new XUSourceLogRecord(Level.FINEST, "path=" + canonicalRulesetPath, new Object[0]));
        }
        if ((engineManagers = this.rulesetUsage.get(canonicalRulesetPath)) != null) {
            engineManagers.remove(engineManager);
        }
    }

    @Override
    public synchronized void startPerformed(EngineManager engineManager) {
        Set<EngineManager> engineManagers;
        String canonicalRulesetPath = this.getCanonicalRulesetPath(engineManager);
        this.isFinestLoggable = this.logger.isLoggable(Level.FINEST);
        this.isFinerLoggable = this.logger.isLoggable(Level.FINER);
        if (this.isFinestLoggable) {
            this.logger.log(new XUSourceLogRecord(Level.FINEST, "path=" + canonicalRulesetPath, new Object[0]));
        }
        if ((engineManagers = this.rulesetUsage.get(canonicalRulesetPath)) == null) {
            engineManagers = new HashSet<EngineManager>();
            this.rulesetUsage.put(canonicalRulesetPath, engineManagers);
        }
        engineManagers.add(engineManager);
        this.lastTimeUsage.put(canonicalRulesetPath, new Long(0L));
    }

    @Override
    public IlrRulesetUsageInformation getRulesetUsageInformation(String canonicalRulesetPath) {
        return this.getRulesetUsageInformationImpl(canonicalRulesetPath, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IlrRulesetUsageInformationImpl getRulesetUsageInformationImpl(String canonicalRulesetPath, boolean create) {
        Map<String, IlrRulesetUsageInformationImpl> map = this.rulesetsInformation;
        synchronized (map) {
            IlrRulesetUsageInformationImpl info = this.rulesetsInformation.get(canonicalRulesetPath);
            if (info == null && create) {
                info = new IlrRulesetUsageInformationImpl(canonicalRulesetPath, this);
                this.rulesetsInformation.put(canonicalRulesetPath, info);
            }
            return info;
        }
    }

    @Override
    public void executeEnded(EngineManager e, long duration) {
        this.executionEnded(e, duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executionEnded(EngineManager engine, long duration) {
        long l;
        IlrRulesetUsageInformationImpl info;
        block7: {
            info = engine.getRulesetUsageInformation();
            try {
                if (IlrMemoryInstrumentation.getMemoryProfiler() == null) break block7;
                IlrRulesetUsageInformationImpl ilrRulesetUsageInformationImpl = info;
                synchronized (ilrRulesetUsageInformationImpl) {
                    info.estimatedMemorySize = engine.getRuleset().getRulesetEstimatedMemorySize();
                }
            }
            catch (IlrProfilerException e) {
                this.logger.severe("XU.ERROR.18000", e, null, null);
            }
        }
        long execCount = info.executionCount.incrementAndGet();
        info.lastExecutionDuration.set(duration);
        info.executionDuration.addAndGet(duration);
        while (duration > (l = info.longestExecutionDuration.longValue()) && !info.longestExecutionDuration.compareAndSet(l, duration)) {
        }
        do {
            l = info.shortestExecutionDuration.longValue();
        } while ((execCount == 1L && l == 0L || duration < l) && !info.shortestExecutionDuration.compareAndSet(l, duration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParametersPerformed(EngineManager engineManager, long duration) {
        IlrRulesetUsageInformationImpl info;
        IlrRulesetUsageInformationImpl ilrRulesetUsageInformationImpl = info = engineManager.getRulesetUsageInformation();
        synchronized (ilrRulesetUsageInformationImpl) {
            info.setParametersDuration += duration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rulesetParsed(String canonicalRulesetPath, ClassLoader xomCL, long duration) {
        IlrRulesetUsageInformationImpl info;
        IlrRulesetUsageInformationImpl ilrRulesetUsageInformationImpl = info = this.getRulesetUsageInformationImpl(canonicalRulesetPath, true);
        synchronized (ilrRulesetUsageInformationImpl) {
            info.parsingDuration = duration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getParametersPerformed(EngineManager engineManager, long duration) {
        IlrRulesetUsageInformationImpl info;
        IlrRulesetUsageInformationImpl ilrRulesetUsageInformationImpl = info = engineManager.getRulesetUsageInformation();
        synchronized (ilrRulesetUsageInformationImpl) {
            info.getParametersDuration += duration;
        }
    }

    @Override
    public void executeStarted(EngineManager e) {
        this.executionStarted(e);
    }

    private void executionStarted(EngineManager e) {
        IlrRulesetUsageInformationImpl info = e.getRulesetUsageInformation();
        if (info.firstExecutionTime.get() == 0L) {
            info.firstExecutionTime.compareAndSet(0L, System.currentTimeMillis());
        }
    }

    @Override
    public void executeFailed(EngineManager engineManager, long duration) {
    }

    @Override
    public void executeTaskStarted(String task, EngineManager e) {
        this.executionStarted(e);
    }

    @Override
    public void executeTaskEnded(String task, EngineManager e, long duration) {
        this.executionEnded(e, duration);
    }

    @Override
    public void executeTaskFailed(String task, EngineManager engineManager, long duration) {
    }

    private String getCanonicalRulesetPath(EngineManager e) {
        return e.getCanonicalRulesetPath().toString();
    }
}

