/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.xu.ruleset.trace.internal;

import com.ibm.rules.res.logging.internal.XUSourceLogRecord;
import com.ibm.rules.res.xu.client.internal.ChannelMessage;
import com.ibm.rules.res.xu.engine.internal.EngineManager;
import com.ibm.rules.res.xu.log.internal.LogHandler;
import com.ibm.rules.res.xu.ruleset.internal.XURulesetImpl;
import ilog.rules.res.session.ruleset.IlrExecutionEvent;
import ilog.rules.res.session.ruleset.IlrRuleInformation;
import ilog.rules.res.session.ruleset.IlrTaskEvent;
import ilog.rules.res.session.ruleset.IlrTaskInformation;
import ilog.rules.res.xu.cci.ruleset.impl.IlrRuleEventImpl;
import ilog.rules.res.xu.cci.ruleset.impl.IlrTaskEventImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;

public abstract class IlrRulesetExecutionTraceTool {
    protected List<IlrExecutionEvent> executionEvents = new ArrayList<IlrExecutionEvent>();
    protected Set<String> firedRules = new HashSet<String>();
    protected Set<String> tasksExecuted = new HashSet<String>();
    protected Stack<IlrTaskEventImpl> currentTasks = new Stack();
    protected Stack<IlrRuleEventImpl> currentRules = new Stack();
    protected int numberOfTasksExecuted = 0;
    protected int filter;
    protected List<String> workingMemoryClassNames;
    protected boolean boundObjects;
    protected int totalRulesFired = 0;
    private final LogHandler logger;
    protected List<ChannelMessage> messages = new ArrayList<ChannelMessage>();
    private boolean finestLogEnabled;
    private final Map<String, IlrRuleInformation> allRules;
    private final Map<String, IlrTaskInformation> allTasks;

    public IlrRulesetExecutionTraceTool(LogHandler logger, Map<String, IlrRuleInformation> allRules, Map<String, IlrTaskInformation> allTasks) {
        this.allRules = allRules;
        this.allTasks = allTasks;
        this.logger = logger;
    }

    public synchronized void setFilter(int filter, Map<String, String> filterProperties) {
        this.finestLogEnabled = this.logger.isLoggable(Level.FINEST);
        if (this.finestLogEnabled) {
            this.logger.log(new XUSourceLogRecord.Entry(filter, filterProperties));
        }
        this.filter = filter;
        if (filterProperties == null) {
            this.workingMemoryClassNames = new ArrayList<String>();
            this.boundObjects = true;
        } else {
            String prop = filterProperties.get("WORKING_MEMORY_CLASS_NAMES");
            if (prop == null) {
                this.workingMemoryClassNames = new ArrayList<String>();
            } else {
                prop = prop.trim();
                String[] names = prop.split(",");
                this.workingMemoryClassNames = Arrays.asList(names);
            }
            prop = filterProperties.get("BOUND_OBJECTS");
            this.boundObjects = prop == null || !prop.equals("false");
        }
        if (this.finestLogEnabled) {
            this.logger.log(new XUSourceLogRecord.Exit());
        }
    }

    public synchronized long getNumberOfTasksExecuted() {
        return this.numberOfTasksExecuted;
    }

    public synchronized Set<String> getFiredRules() {
        return this.firedRules;
    }

    public synchronized Collection<Object> getWorkingMemory(EngineManager engine) {
        Object[] wm = engine.getWorkingMemory();
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < wm.length; ++i) {
            Object object = wm[i];
            if (this.workingMemoryClassNames.size() != 0 && !this.workingMemoryClassNames.contains(object.getClass().getName())) continue;
            result.add(wm[i]);
        }
        return result;
    }

    public synchronized Set<IlrRuleInformation> getRulesNotFired(Map<String, IlrRuleInformation> allRulesetRules) {
        HashSet<IlrRuleInformation> rulesNotFired = new HashSet<IlrRuleInformation>();
        for (Map.Entry<String, IlrRuleInformation> e : allRulesetRules.entrySet()) {
            String name = e.getKey();
            if (this.firedRules.contains(name)) continue;
            rulesNotFired.add(e.getValue());
        }
        return rulesNotFired;
    }

    public synchronized Set<String> getTasksExecuted() {
        return this.tasksExecuted;
    }

    public synchronized Set<String> getTasksNotExecuted(XURulesetImpl ruleset) {
        Map<String, IlrTaskInformation> allTasks = ruleset.getTasks();
        HashSet<String> tasksNotExecuted = new HashSet<String>();
        for (String taskName : allTasks.keySet()) {
            if (this.tasksExecuted.contains(taskName)) continue;
            tasksNotExecuted.add(taskName);
        }
        return tasksNotExecuted;
    }

    public synchronized List<IlrExecutionEvent> getExecutionEvents() {
        return this.executionEvents;
    }

    public synchronized List<ChannelMessage> getMessages() {
        return this.messages;
    }

    public synchronized void ruleStarted(String rName, int priority, Object[] objs, String aName) {
        int mask;
        if (this.finestLogEnabled) {
            this.logger.log(new XUSourceLogRecord.Entry(new Object[]{rName, priority, objs, aName}));
        }
        if (((mask = 82) & this.filter) == 0) {
            return;
        }
        List<Object> evtObjs = this.boundObjects ? Arrays.asList(objs) : null;
        this.firedRules.add(rName);
        Date sDate = new Date(System.currentTimeMillis());
        IlrRuleEventImpl evt = new IlrRuleEventImpl(rName, sDate, null, priority, evtObjs, aName, this.allRules.get(rName));
        this.currentRules.add(evt);
        if (!this.currentTasks.isEmpty()) {
            this.currentTasks.peek().getSubExecutionEvents().add(evt);
        } else {
            this.executionEvents.add(evt);
        }
        if (this.finestLogEnabled) {
            this.logger.log(new XUSourceLogRecord.Exit());
        }
    }

    public synchronized void taskStarted(String taskName) {
        int mask;
        if (this.finestLogEnabled) {
            this.logger.log(new XUSourceLogRecord.Entry(taskName));
        }
        if (((mask = 163) & this.filter) == 0) {
            return;
        }
        Date taskStartDate = new Date(System.currentTimeMillis());
        this.tasksExecuted.add(taskName);
        ++this.numberOfTasksExecuted;
        IlrTaskEventImpl task = new IlrTaskEventImpl(taskName, taskStartDate, null, this.allTasks.get(taskName));
        if (this.currentTasks.isEmpty()) {
            this.executionEvents.add(task);
        } else {
            IlrTaskEvent parentTask = this.currentTasks.peek();
            parentTask.getSubExecutionEvents().add(task);
        }
        this.currentTasks.push(task);
        if (this.finestLogEnabled) {
            this.logger.log(new XUSourceLogRecord.Exit());
        }
    }

    public synchronized void ruleEnded(String ruleName, int priority, Object[] tuple) {
        if (this.finestLogEnabled) {
            this.logger.log(new XUSourceLogRecord.Entry(new Object[]{ruleName, priority, tuple}));
        }
        ++this.totalRulesFired;
        int mask = 82;
        if ((mask & this.filter) == 0) {
            return;
        }
        long endDate = System.currentTimeMillis();
        this.currentRules.pop().setEndDate(new Date(endDate));
        if (this.finestLogEnabled) {
            this.logger.log(new XUSourceLogRecord.Exit());
        }
    }

    public synchronized void taskEnded(String taskName) {
        int mask;
        if (this.finestLogEnabled) {
            this.logger.log(new XUSourceLogRecord.Entry(taskName));
        }
        if (((mask = 163) & this.filter) == 0) {
            return;
        }
        long endDate = System.currentTimeMillis();
        this.currentTasks.pop().setEndDate(new Date(endDate));
        if (this.finestLogEnabled) {
            this.logger.log(new XUSourceLogRecord.Exit());
        }
    }

    public synchronized void reset() {
        if (this.finestLogEnabled) {
            this.logger.log(new XUSourceLogRecord.Entry(new Object[0]));
        }
        this.executionEvents = new ArrayList<IlrExecutionEvent>();
        this.firedRules = new HashSet<String>();
        this.tasksExecuted = new HashSet<String>();
        this.currentTasks = new Stack();
        this.currentRules = new Stack();
        this.numberOfTasksExecuted = 0;
        this.totalRulesFired = 0;
        this.messages = new ArrayList<ChannelMessage>();
        if (this.finestLogEnabled) {
            this.logger.log(new XUSourceLogRecord.Exit());
        }
    }

    public synchronized int getTotalRulesFired() {
        return this.totalRulesFired;
    }
}

