/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.xu.spi;

import com.ibm.rules.res.xu.log.internal.LogHandler;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.resource.cci.Connection;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ManagedConnection;

public final class IlrConnectionEventListenerSupport {
    private final ManagedConnection connection;
    private final ArrayList<ConnectionEventListener> listeners = new ArrayList();
    private final LogHandler logger;
    private final Boolean duplicateConnectionEventListenerEnabled;
    private final boolean isFinestLoggable;

    public IlrConnectionEventListenerSupport(ManagedConnection conn, LogHandler logger, Boolean duplicateConnectionEventListenerEnabled) {
        this.connection = conn;
        this.logger = logger;
        this.duplicateConnectionEventListenerEnabled = duplicateConnectionEventListenerEnabled;
        this.isFinestLoggable = logger.isLoggable(Level.FINEST);
    }

    public synchronized void add(ConnectionEventListener listener) {
        if (!this.duplicateConnectionEventListenerEnabled.booleanValue()) {
            for (ConnectionEventListener l : this.listeners) {
                if (l != listener) continue;
                if (this.isFinestLoggable) {
                    this.logFinest(".add: duplicate connection event listener " + listener + " detected");
                }
                return;
            }
        }
        this.listeners.add(listener);
    }

    public synchronized void remove(ConnectionEventListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void connectionClosed(Connection conn) {
        if (this.isFinestLoggable) {
            this.logFinest(".connectionClosed");
        }
        ConnectionEvent evt = new ConnectionEvent(this.connection, 1);
        evt.setConnectionHandle((Object)conn);
        IlrConnectionEventListenerSupport ilrConnectionEventListenerSupport = this;
        synchronized (ilrConnectionEventListenerSupport) {
            for (ConnectionEventListener l : this.listeners) {
                l.connectionClosed(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void localTransactionCommitted() {
        if (this.isFinestLoggable) {
            this.logFinest(".localTransactionCommitted");
        }
        ConnectionEvent evt = new ConnectionEvent(this.connection, 3);
        IlrConnectionEventListenerSupport ilrConnectionEventListenerSupport = this;
        synchronized (ilrConnectionEventListenerSupport) {
            for (ConnectionEventListener l : this.listeners) {
                l.localTransactionCommitted(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void connectionErrorOccurred() {
        if (this.isFinestLoggable) {
            this.logFinest(".connectionErrorOccurred");
        }
        ConnectionEvent evt = new ConnectionEvent(this.connection, 5);
        IlrConnectionEventListenerSupport ilrConnectionEventListenerSupport = this;
        synchronized (ilrConnectionEventListenerSupport) {
            for (ConnectionEventListener l : this.listeners) {
                l.connectionErrorOccurred(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void localTransactionRolledback() {
        if (this.isFinestLoggable) {
            this.logFinest(".localTransactionRolledback");
        }
        ConnectionEvent evt = new ConnectionEvent(this.connection, 4);
        IlrConnectionEventListenerSupport ilrConnectionEventListenerSupport = this;
        synchronized (ilrConnectionEventListenerSupport) {
            for (ConnectionEventListener l : this.listeners) {
                l.localTransactionRolledback(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void localTransactionStarted() {
        if (this.isFinestLoggable) {
            this.logFinest(".localTransactionStarted");
        }
        ConnectionEvent evt = new ConnectionEvent(this.connection, 2);
        IlrConnectionEventListenerSupport ilrConnectionEventListenerSupport = this;
        synchronized (ilrConnectionEventListenerSupport) {
            for (ConnectionEventListener l : this.listeners) {
                l.localTransactionStarted(evt);
            }
        }
    }

    private void logFinest(String msg) {
        this.logger.finest(this.getClass().getName() + msg);
    }
}

