/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.xu.spi;

import com.ibm.rules.engine.connector.DataConnectorException;
import com.ibm.rules.res.message.internal.XUMessageCode;
import com.ibm.rules.res.xu.bom.internal.BOMConverter;
import com.ibm.rules.res.xu.bom.internal.DocumentBuilderPool;
import com.ibm.rules.res.xu.bom.internal.TransformerPool;
import com.ibm.rules.res.xu.client.internal.RulesetExecutionListener;
import com.ibm.rules.res.xu.client.internal.XURulesetParameter;
import com.ibm.rules.res.xu.engine.cre.internal.CREManager;
import com.ibm.rules.res.xu.engine.cre.internal.ContextFactory;
import com.ibm.rules.res.xu.engine.de.internal.DEManager;
import com.ibm.rules.res.xu.engine.internal.BaseEngineManager;
import com.ibm.rules.res.xu.engine.internal.EngineManager;
import com.ibm.rules.res.xu.internal.LocalizedNotSupportedException;
import com.ibm.rules.res.xu.internal.LocalizedResourceException;
import com.ibm.rules.res.xu.internal.XUException;
import com.ibm.rules.res.xu.log.internal.LogHandler;
import com.ibm.rules.res.xu.persistence.internal.Persistence;
import com.ibm.rules.res.xu.ruleset.internal.RulesetParsingWork;
import com.ibm.rules.res.xu.ruleset.internal.XURulesetImpl;
import com.ibm.rules.res.xu.spi.internal.ManagedXUConnectionMetaData;
import com.ibm.rules.res.xu.spi.internal.RulesetExecutionWork;
import ilog.rules.archive.IlrInternalRulesetArchiveHelper;
import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.bres.xu.event.IlrConnectorEvent;
import ilog.rules.bres.xu.event.IlrConnectorEventListener;
import ilog.rules.bres.xu.event.IlrProfilingRulesetEvent;
import ilog.rules.bres.xu.event.IlrProfilingSessionEvent;
import ilog.rules.bres.xu.event.IlrRulesetArchiveEvent;
import ilog.rules.bres.xu.event.IlrRulesetArchiveEventListener;
import ilog.rules.bres.xu.profiling.IlrProfilingHelper;
import ilog.rules.engine.IlrContext;
import ilog.rules.res.model.IlrCRERulesetArchive;
import ilog.rules.res.model.IlrEngineType;
import ilog.rules.res.model.IlrRulesetArchiveInformationBase;
import ilog.rules.res.xu.IlrXUContext;
import ilog.rules.res.xu.cci.IlrConnectionId;
import ilog.rules.res.xu.cci.IlrInteractionExtension;
import ilog.rules.res.xu.cci.IlrXUConnection;
import ilog.rules.res.xu.cci.ruleset.IlrRulesetExecutionTrace;
import ilog.rules.res.xu.event.internal.IlrXUEventDispatcher;
import ilog.rules.res.xu.ruleset.IlrRulesetCache;
import ilog.rules.res.xu.ruleset.IlrRulesetCacheException;
import ilog.rules.res.xu.ruleset.IlrXURuleset;
import ilog.rules.res.xu.ruleset.archive.internal.IlrRulesetArchiveInformationNotFoundException;
import ilog.rules.res.xu.ruleset.archive.internal.IlrXURulesetArchiveInformation;
import ilog.rules.res.xu.ruleset.cache.internal.IlrRulesetCacheImpl;
import ilog.rules.res.xu.ruleset.internal.IlrRulesetAlreadyParsingException;
import ilog.rules.res.xu.ruleset.internal.IlrRulesetProvider;
import ilog.rules.res.xu.ruleset.internal.IlrRulesetUsageInformationImpl;
import ilog.rules.res.xu.ruleset.internal.IlrRulesetUsageInformationMonitorImpl;
import ilog.rules.res.xu.spi.IlrConnectionContextManager;
import ilog.rules.res.xu.spi.IlrConnectionEventListenerSupport;
import ilog.rules.res.xu.spi.IlrManagedConnectionContext;
import ilog.rules.res.xu.spi.IlrManagedXUConnectionContext;
import ilog.rules.res.xu.spi.IlrManagedXUConnectionFactory;
import ilog.rules.res.xu.spi.IlrXUConnectionRequestInfo;
import ilog.rules.xml.IlrXmlObject;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkManager;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

public class IlrManagedXUConnection
implements ManagedConnection,
IlrRulesetArchiveEventListener,
IlrConnectorEventListener,
RulesetParsingWork.Listener {
    IlrXURuleset lastLoadedRuleset;
    protected byte state = (byte)-1;
    protected long lastRunningTime = -1L;
    protected byte type = (byte)-1;
    protected String rulesetPath;
    protected IlrConnectionEventListenerSupport connListeners;
    protected IlrProfilingHelper profilingHelper;
    private LogHandler logger;
    private final boolean isFinestLoggable;
    private final boolean isFinerLoggable;
    private final boolean isFineLoggable;
    protected ClassLoader xomClassLoader;
    protected IlrConnectionContextManager connectionContexts = new IlrConnectionContextManager();
    protected ArrayList<EngineManager> freeEngineManagers = new ArrayList();
    protected IlrManagedXUConnectionFactory factory;
    protected IlrConnectionId connectionId;
    protected IlrManagedXUConnectionContext context;
    protected Object dataConnectorFactory;

    public IlrManagedXUConnection(IlrConnectionId connectionId, byte type, String rulesetPath, ClassLoader xomClassLoader, Object dataConnectorFactory, IlrManagedXUConnectionFactory factory, LogHandler logger) {
        this.connectionId = connectionId;
        this.context = new IlrManagedXUConnectionContext(connectionId, rulesetPath);
        this.type = type;
        this.rulesetPath = rulesetPath;
        this.xomClassLoader = xomClassLoader;
        this.factory = factory;
        this.dataConnectorFactory = dataConnectorFactory;
        this.profilingHelper = factory.getProfiling();
        IlrXUEventDispatcher dispatcher = this.getEventDispatcher();
        this.logger = logger;
        this.isFinestLoggable = logger.isLoggable(Level.FINEST);
        this.isFinerLoggable = logger.isLoggable(Level.FINER);
        this.isFineLoggable = logger.isLoggable(Level.FINE);
        dispatcher.addListener(this, 8193L);
        this.connListeners = new IlrConnectionEventListenerSupport(this, logger, factory.isDuplicateConnectionEventListenerEnabled());
        this.state = 0;
    }

    public final synchronized long getLastRunningTime() {
        return this.lastRunningTime;
    }

    protected final synchronized void setState(byte newState) {
        if (newState == 3) {
            this.lastRunningTime = 0L;
        } else if (this.state == 3) {
            this.lastRunningTime = System.currentTimeMillis();
        }
        this.state = newState;
    }

    public IlrConnectionId getId() {
        return this.connectionId;
    }

    public Map<String, Object> getConnectorConfigProperties() throws XUException {
        return this.factory.getConnectorConfigProperties();
    }

    public DocumentBuilderPool getCREBOMDocumentBuilderPool() throws XUException {
        return this.factory.getCREDocumentBuilderPool();
    }

    public IlrRulesetUsageInformationImpl getRulesetUsageInformation(String canonicalRulesetPath) throws XUException {
        IlrRulesetUsageInformationMonitorImpl monitor = this.factory.getRulesetUsageMonitor();
        if (monitor == null) {
            throw new XUException("XU.ERROR.20000", null, null);
        }
        return monitor.getRulesetUsageInformationImpl(canonicalRulesetPath, true);
    }

    public void startMaintenanceTasks() throws XUException {
        IlrRulesetCache cache = this.factory.getRulesetProvider().getCache();
        if (cache instanceof IlrRulesetCacheImpl) {
            ((IlrRulesetCacheImpl)cache).runMaintenanceTask();
        }
    }

    public IlrManagedXUConnectionFactory getFactory() {
        return this.factory;
    }

    public IlrProfilingHelper getProfiling() {
        return this.factory.getProfiling();
    }

    public IlrInteractionExtension[] getInteractionExtensions() {
        return this.factory.getInteractionExtensions();
    }

    public synchronized byte getState() {
        return this.state;
    }

    public IlrXUEventDispatcher getEventDispatcher() {
        return this.factory.getEventDispatcher();
    }

    public byte getType() {
        return this.type;
    }

    public LogHandler getLogHandler() {
        return this.logger;
    }

    public final PrintWriter getLogWriter() {
        return this.logger.getLogWriter();
    }

    public final void setLogWriter(PrintWriter writer) {
    }

    private Persistence getPersistence() throws XUException {
        return this.factory.getPersistence(true);
    }

    public IlrRulesetProvider getRulesetProvider() throws XUException {
        return this.factory.getRulesetProvider();
    }

    public ContextFactory getContextFactory() {
        return this.factory.getContextFactory();
    }

    public String solveRulesetPath(String rulesetPath) throws XUException {
        return this.getPersistence().getCanonicalRulesetPath(rulesetPath);
    }

    public void notifyRulesetArchiveChanged(String canonicalRulesetPath, IlrXUContext ctx) {
        this.factory.notifyRulesetArchiveChanged(canonicalRulesetPath, ctx);
    }

    public void startProfilingSession(Properties parameters, IlrXUContext xuContext) {
        IlrProfilingSessionEvent evt = new IlrProfilingSessionEvent(1, this, parameters, xuContext);
        this.getEventDispatcher().profilingSessionActionPerformed(evt);
    }

    public void stopProfilingSession(Properties parameters, IlrXUContext xuContext) {
        IlrProfilingSessionEvent evt = new IlrProfilingSessionEvent(2, this, parameters, xuContext);
        this.getEventDispatcher().profilingSessionActionPerformed(evt);
    }

    public final synchronized void closeAll() throws ResourceException {
        for (IlrXUConnection conn : this.connectionContexts.getConnections()) {
            this.close(conn);
        }
    }

    private void closeConnection(IlrXUConnection conn) throws ResourceException {
        if (this.isFinestLoggable) {
            this.logFinest(".close " + this, conn.getContext());
        }
        conn.closed();
        this.dissociateEngineManager(conn);
        this.connListeners.connectionClosed(conn);
        this.factory.notifyConnectionClosed(conn);
        if (this.isFinestLoggable) {
            this.logFinest(".close done " + this, conn.getContext());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close(IlrXUConnection conn) throws ResourceException {
        block12: {
            try {
                if (this.factory.isConcurrentOpenClose() == Boolean.TRUE) {
                    IlrManagedXUConnection ilrManagedXUConnection = this;
                    synchronized (ilrManagedXUConnection) {
                        this.closeConnection(conn);
                        break block12;
                    }
                }
                Object object = this.factory.connectionManagerLock;
                synchronized (object) {
                    IlrManagedXUConnection ilrManagedXUConnection = this;
                    synchronized (ilrManagedXUConnection) {
                        this.closeConnection(conn);
                    }
                }
            }
            catch (XUException e) {
                throw IlrManagedXUConnection.createResourceException(e);
            }
        }
    }

    private void dissociateEngineManager(IlrXUConnection conn) {
        this.connectionContexts.remove(conn);
        EngineManager engineMgr = conn.getEngineManager();
        if (engineMgr != null) {
            engineMgr.cleanup();
            this.freeEngineManagers.add(engineMgr);
        }
    }

    public final boolean match(ConnectionRequestInfo connRqInfo) throws ResourceException {
        if (this.state == 2) {
            this.logger.info("XU.INFO.8007", null);
            return false;
        }
        if (connRqInfo instanceof IlrXUConnectionRequestInfo) {
            IlrXUConnectionRequestInfo rqInfo = (IlrXUConnectionRequestInfo)connRqInfo;
            if (this.type == -1) {
                return true;
            }
            if (this.type == rqInfo.getType() && this.type == 0) {
                if (this.rulesetPath.equals(rqInfo.getRulesetPath()) && this.xomClassLoader == rqInfo.getXOMClassLoader() && this.dataConnectorFactory == rqInfo.getDataConnectorFactory()) {
                    return true;
                }
                if (this.type == 1) {
                    return true;
                }
            }
        } else {
            throw new LocalizedNotSupportedException("XU.ERROR.10002", new String[]{connRqInfo.toString()});
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getConnection(Subject subject, ConnectionRequestInfo connRq) throws ResourceException {
        if (this.isFinestLoggable) {
            this.logFinest(".getConnection " + this, this.context);
            this.logFinest(".getConnection " + connRq, this.context);
        }
        IlrXUConnectionRequestInfo xuConnRq = (IlrXUConnectionRequestInfo)connRq;
        if (this.type == -1) {
            this.type = xuConnRq.getType();
            this.rulesetPath = xuConnRq.getRulesetPath();
            this.context.setRulesetPath(this.rulesetPath);
            this.xomClassLoader = xuConnRq.getXOMClassLoader();
        }
        IlrXUConnection conn = this.createXUConnection(xuConnRq);
        IlrManagedXUConnection ilrManagedXUConnection = this;
        synchronized (ilrManagedXUConnection) {
            this.connectionContexts.add(conn);
        }
        this.factory.addConnection(conn);
        this.factory.notifyConnectionOpened(conn);
        this.setState((byte)1);
        return conn;
    }

    private IlrXUConnection createXUConnection(IlrXUConnectionRequestInfo rqInfo) {
        IlrConnectionId id = this.factory.getConnectionIdGenerator().nextConnectionId();
        IlrXUConnection conn = new IlrXUConnection(id, this, rqInfo);
        if (this.isFinerLoggable) {
            this.logger.finer("XU.FINER.4203", new Object[]{this, conn}, conn.getContext());
        }
        return conn;
    }

    public synchronized void destroy() throws ResourceException {
        if (this.isFinestLoggable) {
            this.logFinest(".destroy rulesetPath=" + this.rulesetPath + " ref=" + this, this.context);
        }
        if (this.state == 2) {
            return;
        }
        IlrXUEventDispatcher dispatcher = this.getEventDispatcher();
        dispatcher.removeListener(this, 8193L);
        Collection<IlrXUConnection> conns = this.connectionContexts.getConnections();
        for (IlrXUConnection conn : conns) {
            conn.closed();
        }
        for (IlrXUConnection conn : conns) {
            EngineManager mgr = conn.getEngineManager();
            if (mgr == null) continue;
            mgr.destroy();
        }
        for (EngineManager freeMgr : this.freeEngineManagers) {
            freeMgr.destroy();
        }
        this.connectionContexts = null;
        this.freeEngineManagers = null;
        this.lastLoadedRuleset = null;
        this.factory = null;
        this.logger = null;
        this.context = null;
        this.connListeners = null;
        this.dataConnectorFactory = null;
        this.profilingHelper = null;
        this.xomClassLoader = null;
        this.connectionId = null;
        this.setState((byte)2);
    }

    public synchronized void cleanup() throws ResourceException {
        if (this.isFinerLoggable) {
            this.logger.finer("XU.FINER.4201", new Object[]{this}, this.context);
        }
        if (this.state == 0 || this.state == 2) {
            if (this.isFinestLoggable) {
                this.logFinest(".cleanup " + this + " already done", this.context);
            }
            return;
        }
        for (IlrXUConnection conn : this.connectionContexts.getConnections()) {
            conn.closed();
            this.connectionContexts.remove(conn);
        }
        this.setState((byte)0);
        if (this.isFinerLoggable) {
            this.logger.finer("XU.FINER.4202", new Object[]{this}, this.context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associateConnection(Object conn) throws ResourceException {
        if (this.isFinestLoggable) {
            this.logFinest(".associateConnection " + conn + " use " + ((IlrXUConnection)conn).getManagedConnection(), this.context);
            this.logFinest(".associateConnection " + conn + " to " + this, this.context);
        }
        if (!(conn instanceof IlrXUConnection)) {
            throw new LocalizedNotSupportedException("XU.ERROR.10002", new String[]{"class: " + conn.getClass().getName()});
        }
        try {
            IlrXUConnection xuConn = (IlrXUConnection)conn;
            if (xuConn.getState() == 2) {
                throw new LocalizedResourceException("XU.ERROR.10044", null);
            }
            IlrManagedXUConnection spiConn = xuConn.getManagedConnection();
            if (spiConn == this) {
                return;
            }
            if (xuConn.getSpec().getType() == 0) {
                EngineManager engineMgr;
                IlrManagedXUConnection ilrManagedXUConnection = spiConn;
                synchronized (ilrManagedXUConnection) {
                    engineMgr = spiConn.getEngineManager(xuConn, false);
                }
                ilrManagedXUConnection = this;
                synchronized (ilrManagedXUConnection) {
                    engineMgr.setManagedConnection(this);
                    this.connectionContexts.add(xuConn);
                    xuConn.setEngineManager(engineMgr);
                }
                ilrManagedXUConnection = spiConn;
                synchronized (ilrManagedXUConnection) {
                    spiConn.connectionContexts.remove(xuConn);
                }
            }
            xuConn.setManagedConnection(this);
        }
        catch (XUException e) {
            this.logger.severe("XU.ERROR.10070", e, null, null);
            throw new ResourceException((Throwable)e);
        }
    }

    public void addConnectionEventListener(ConnectionEventListener l) {
        if (this.isFinestLoggable) {
            this.logFinest(".addConnectionEventListener " + l, this.context);
        }
        this.connListeners.add(l);
    }

    public void removeConnectionEventListener(ConnectionEventListener l) {
        if (this.logger != null && this.isFinestLoggable) {
            this.logFinest(".removeConnectionEventListener() " + this, this.context);
        }
        if (this.connListeners != null) {
            this.connListeners.remove(l);
        }
    }

    public synchronized XAResource getXAResource() throws ResourceException {
        LocalizedNotSupportedException e = new LocalizedNotSupportedException("XU.ERROR.10002", new String[]{"ManagedConnection.getXAResource"});
        this.logger.severe("XU.ERROR.10002", (Throwable)((Object)e), null, null);
        throw e;
    }

    public synchronized LocalTransaction getLocalTransaction() throws ResourceException {
        throw new LocalizedNotSupportedException(XUMessageCode.ERROR_TRANSACTION_NOT_SUPPORTED);
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return ManagedXUConnectionMetaData.singleton;
    }

    @Override
    public synchronized void connectorEventRaised(IlrConnectorEvent event) {
        String prop;
        if (this.state == 2 || this.type != 0) {
            return;
        }
        if (event.getCode() == 0 && ((prop = event.getPropertyName()).equals("persistenceProperties") || prop.equals("persistenceType"))) {
            this.setUptodate(this.connectionContexts.getConnections(), false);
            this.removeAllFreeEngineManagers();
        }
    }

    @Override
    public final synchronized void changePerformed(IlrRulesetArchiveEvent event) {
        String path;
        if (this.state == 2) {
            return;
        }
        if (this.isFinestLoggable) {
            this.logFinest(".updatePerformed: " + event, this.context);
        }
        if (this.type != 0) {
            return;
        }
        String updatedPath = event.getCanonicalRulesetPath();
        String newPath = null;
        try {
            newPath = this.getPersistence().getCanonicalRulesetPath(this.rulesetPath);
        }
        catch (Exception e) {
            if (e instanceof IlrRulesetArchiveInformationNotFoundException) {
                if (this.isFinestLoggable) {
                    this.logFinest(" " + this + ": ruleset does not exist", this.context);
                }
            } else {
                this.logger.severe("XU.ERROR.10049", e, new Object[]{this.rulesetPath}, null);
            }
            if (this.isFinestLoggable) {
                this.logFinest("ManagedConnection " + this + " removing free engine manager, " + " used engine managers are marked as not uptodate", this.context);
            }
            this.setUptodate(this.connectionContexts.getConnections(), false);
            this.removeAllFreeEngineManagers();
        }
        for (EngineManager engineMgr : this.freeEngineManagers) {
            path = engineMgr.getRuleset().getCanonicalRulesetPath();
            if (!path.equals(updatedPath) && path.equals(newPath)) continue;
            if (this.isFinestLoggable) {
                this.logFinest(this + ": EngineManager " + engineMgr + " no more uptodate", this.context);
            }
            engineMgr.setUptodate(false);
        }
        for (IlrXUConnection conn : this.connectionContexts.getConnections()) {
            EngineManager engineMgr = conn.getEngineManager();
            if (engineMgr == null || !(path = engineMgr.getRuleset().getCanonicalRulesetPath()).equals(updatedPath) && path.equals(newPath)) continue;
            if (this.isFinestLoggable) {
                this.logFinest(this + ": Removing free EngineManager " + engineMgr + " which is no more uptodate", this.context);
            }
            engineMgr.setUptodate(false);
        }
    }

    private void setUptodate(Collection<IlrXUConnection> conns, boolean uptodate) {
        for (IlrXUConnection conn : conns) {
            EngineManager engineMgr = conn.getEngineManager();
            if (engineMgr == null) continue;
            engineMgr.setUptodate(uptodate);
        }
    }

    protected void removeAllFreeEngineManagers() {
        Iterator<EngineManager> engineMgrs = this.freeEngineManagers.iterator();
        while (engineMgrs.hasNext()) {
            EngineManager engineMgr = engineMgrs.next();
            if (this.isFinestLoggable) {
                this.logFinest(".removeAllFreenEgineManagers(): " + this + ": removing free EngineManager " + engineMgr + " which is no more uptodate", this.context);
            }
            engineMgr.setUptodate(false);
            engineMgr.destroy();
            engineMgrs.remove();
        }
    }

    protected void removeNotUptodateFreeEngineManagers() {
        Iterator<EngineManager> engineManagers = this.freeEngineManagers.iterator();
        while (engineManagers.hasNext()) {
            EngineManager engineManager = engineManagers.next();
            if (engineManager.isUptodate()) continue;
            engineManager.destroy();
            engineManagers.remove();
        }
    }

    public final synchronized void asynchronousExecuteRuleset(RulesetExecutionListener listener, IlrXUConnection conn) throws XUException {
        this.setState((byte)3);
        if (this.isFinestLoggable) {
            this.logFinest(".asynchronousExecuteRuleset()", null);
        }
        try {
            WorkManager workMgr = this.factory.getResourceAdapter().getWorkManager();
            EngineManager mgr = this.getEngineManager(conn, false);
            RulesetExecutionWork work = new RulesetExecutionWork(mgr, listener, this.logger);
            workMgr.startWork((Work)work);
            if (this.isFinestLoggable) {
                this.logFinest(".asynchronousExecuteRuleset(): ends", null);
            }
        }
        catch (WorkException e) {
            throw new XUException("XU.ERROR.10408", e);
        }
        finally {
            this.setState((byte)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void loadUptodateRuleset(IlrXUConnection conn) throws XUException {
        this.setState((byte)3);
        try {
            this.getEngineManager(conn, true);
        }
        finally {
            this.setState((byte)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void engineExecute(IlrXUConnection conn, Map<String, Object> outParams) throws XUException {
        this.setState((byte)3);
        try {
            this.getEngineManager(conn, false).execute(outParams);
            if (this.isFineLoggable) {
                this.logger.fine("XU.FINE.5056", new Object[]{outParams}, conn.getContext());
            }
        }
        finally {
            this.setState((byte)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized int engineGetFiredRulesCount(IlrXUConnection conn) throws XUException {
        this.setState((byte)3);
        try {
            int n = this.getEngineManager(conn, false).getFiredRulesCount();
            return n;
        }
        finally {
            this.setState((byte)1);
        }
    }

    protected static ResourceException createResourceException(Exception e) throws ResourceException {
        if (e instanceof ResourceException) {
            return (ResourceException)((Object)e);
        }
        return new ResourceException((Throwable)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void contextGetParameters(IlrXUConnection conn, byte dir, Map<String, Object> params) throws XUException {
        this.setState((byte)3);
        try {
            this.getEngineManager(conn, false).getParameters(dir, params);
        }
        finally {
            this.setState((byte)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void engineGetXOMParameters(IlrXUConnection conn, byte dir, Map<String, Object> params) throws XUException {
        this.setState((byte)3);
        try {
            this.getEngineManager(conn, false).getXOMParameters(dir, params);
        }
        finally {
            this.setState((byte)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Map<String, String> engineGetParametersAsBOM(IlrXUConnection conn, byte dir, List<String> filters, boolean roAtts, BOMConverter.ObjectKind kind) throws XUException {
        this.setState((byte)3);
        try {
            EngineManager mgr = this.getEngineManager(conn, false);
            Map<String, String> map = mgr.getParametersAsBOM(dir, filters, roAtts, kind, conn);
            return map;
        }
        finally {
            this.setState((byte)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object engineExecuteMain(IlrXUConnection conn, Object param) throws XUException {
        this.setState((byte)3);
        try {
            Object result = ((CREManager)this.getEngineManager(conn, false)).executeMain(param);
            this.logger.fine("XU.FINE.5057", new Object[]{result}, conn.getContext());
            Object object = result;
            return object;
        }
        finally {
            this.setState((byte)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void contextExecuteTask(IlrXUConnection conn, String task, Map<String, Object> params) throws XUException {
        this.setState((byte)3);
        try {
            this.getEngineManager(conn, false).executeTask(task, params);
            this.logger.fine("XU.FINE.5058", new Object[]{params}, conn.getContext());
        }
        finally {
            this.setState((byte)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized String[] engineToBOM(IlrXUConnection conn, List<Object> objs, BOMConverter.ObjectKind kind) throws XUException {
        this.setState((byte)3);
        try {
            String[] stringArray = this.getEngineManager(conn, false).toBOM(objs, kind, conn);
            return stringArray;
        }
        finally {
            this.setState((byte)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized IlrXmlObject[] engineToXMLObjects(IlrXUConnection conn, List<String> xmls) throws XUException {
        this.setState((byte)3);
        try {
            IlrXmlObject[] ilrXmlObjectArray = this.getEngineManager(conn, false).toXMLObjects(xmls);
            return ilrXmlObjectArray;
        }
        finally {
            this.setState((byte)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void engineReset(IlrXUConnection conn) throws XUException {
        this.setState((byte)3);
        try {
            this.getEngineManager(conn, false).reset();
        }
        finally {
            this.setState((byte)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void resetRulesetExecutionTrace(IlrXUConnection conn) throws XUException {
        this.setState((byte)3);
        try {
            EngineManager mgr = this.getEngineManager(conn, false);
            mgr.resetRulesetExecutionTrace();
        }
        finally {
            this.setState((byte)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void engineRuleflowReset(IlrXUConnection connectionHandle) throws XUException {
        this.setState((byte)3);
        try {
            EngineManager mgr = this.getEngineManager(connectionHandle, false);
            mgr.resetRuleflow();
        }
        finally {
            this.setState((byte)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] contextGetWorkingMemory(IlrXUConnection conn) throws XUException {
        this.setState((byte)3);
        try {
            Object[] objectArray = this.getEngineManager(conn, false).getWorkingMemory();
            return objectArray;
        }
        finally {
            this.setState((byte)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Map<Object, Object> contextGetWorkingMemoryWithId(IlrXUConnection conn) throws XUException {
        this.setState((byte)3);
        try {
            Map<Object, Object> map = this.getEngineManager(conn, false).getWorkingMemoryWithId();
            return map;
        }
        finally {
            this.setState((byte)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void engineInsert(IlrXUConnection conn, List<Object> objects) throws XUException {
        this.setState((byte)3);
        try {
            this.getEngineManager(conn, false).insert(objects);
        }
        finally {
            this.setState((byte)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void engineInsertWithId(IlrXUConnection conn, List<Object> objects) throws XUException {
        this.setState((byte)3);
        try {
            this.getEngineManager(conn, false).insertWithId(objects);
        }
        finally {
            this.setState((byte)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void engineRetract(IlrXUConnection conn, Object[] objects) throws XUException {
        this.setState((byte)3);
        try {
            this.getEngineManager(conn, false).retract(objects);
        }
        finally {
            this.setState((byte)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void engineRetractById(IlrXUConnection conn, Object[] ids) throws XUException {
        this.setState((byte)3);
        try {
            this.getEngineManager(conn, false).retractById(ids);
        }
        finally {
            this.setState((byte)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void engineUpdate(IlrXUConnection connectionHandle, Object[] objects) throws XUException {
        this.setState((byte)3);
        try {
            this.getEngineManager(connectionHandle, false).update(objects);
        }
        finally {
            this.setState((byte)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Object engineInvokeFunction(IlrXUConnection connectionHandle, String name, Object[] objects) throws XUException {
        this.setState((byte)3);
        try {
            Object object = this.getEngineManager(connectionHandle, false).invokeFunction(name, objects);
            return object;
        }
        finally {
            this.setState((byte)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void engineUpdateById(IlrXUConnection connectionHandle, Object[] objects) throws XUException {
        this.setState((byte)3);
        try {
            this.getEngineManager(connectionHandle, false).updateById(objects);
        }
        finally {
            this.setState((byte)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void enableRulesetExecutionInformation(IlrXUConnection conn, int filter, Map<String, String> props) throws XUException {
        this.setState((byte)3);
        try {
            EngineManager mgr = this.getEngineManager(conn, false);
            mgr.enableRulesetExecutionTrace(filter, props);
        }
        finally {
            this.setState((byte)1);
        }
    }

    public final synchronized void writeLog(String[] msgs) throws XUException {
        this.setState((byte)3);
        for (int i = 0; i < msgs.length; ++i) {
            this.logger.fine("XU.FINE.5059", new Object[]{msgs[i]}, null);
        }
        this.setState((byte)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void engineSetParameters(IlrXUConnection conn, Map<String, Object> params) throws XUException {
        this.setState((byte)3);
        if (this.isFinestLoggable) {
            this.logFinest(".engineSetParameters()", this.context);
            for (String key : params.keySet()) {
                Object value = params.get(key);
                this.logFinest(".setParameters(): parameter " + key + ": " + value, this.context);
            }
        }
        try {
            this.getEngineManager(conn, false).setParameters(params);
        }
        finally {
            this.setState((byte)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void engineSetParametersAsBOM(IlrXUConnection conn, Map<String, String> params, BOMConverter.ObjectKind kind) throws XUException {
        this.setState((byte)3);
        if (this.isFinestLoggable) {
            this.logFinest(".engineSetParametersAsBOM()", this.context);
            for (String key : params.keySet()) {
                String value = params.get(key);
                this.logger.finest(".engineSetParametersAsBOM(): parameter " + key + ": " + value, this.context);
            }
        }
        try {
            EngineManager mgr = this.getEngineManager(conn, false);
            mgr.setParametersAsBOM(params, kind, conn);
        }
        finally {
            this.setState((byte)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized String engineGetOutput(IlrXUConnection conn) throws XUException {
        this.setState((byte)3);
        try {
            String string = this.getEngineManager(conn, false).getOutput(true);
            return string;
        }
        finally {
            this.setState((byte)1);
        }
    }

    public synchronized void localTransactionBegin() throws ResourceException {
        this.getLocalTransaction().begin();
        this.connListeners.localTransactionStarted();
    }

    public synchronized void localTransactionCommit() throws ResourceException {
        this.getLocalTransaction().commit();
        this.connListeners.localTransactionCommitted();
    }

    public synchronized void localTransactionRollback() throws ResourceException {
        this.getLocalTransaction().rollback();
        this.connListeners.localTransactionRolledback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized XURulesetParameter[] getRulesetParameters(IlrXUConnection conn) throws XUException {
        this.setState((byte)3);
        if (this.isFinestLoggable) {
            this.logFinest(".getRulesetParameters()", this.context);
        }
        try {
            XURulesetParameter[] xURulesetParameterArray = this.getEngineManager(conn, false).getRulesetParameters();
            return xURulesetParameterArray;
        }
        finally {
            this.setState((byte)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized IlrRulesetExecutionTrace getRulesetExecutionTrace(IlrXUConnection conn) throws XUException {
        this.setState((byte)3);
        try {
            EngineManager mgr = this.getEngineManager(conn, false);
            IlrRulesetExecutionTrace ilrRulesetExecutionTrace = mgr.getRulesetExecutionTrace();
            return ilrRulesetExecutionTrace;
        }
        finally {
            this.setState((byte)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized IlrXURulesetArchiveInformation getXURulesetArchiveInformation(IlrXUConnection conn) throws XUException {
        this.setState((byte)3);
        if (this.isFinestLoggable) {
            this.logFinest(".getXURulesetArchiveInformation", this.context);
        }
        try {
            EngineManager mgr = this.getEngineManager(conn, false);
            IlrXURulesetArchiveInformation ilrXURulesetArchiveInformation = mgr.getRuleset().getArchive();
            return ilrXURulesetArchiveInformation;
        }
        finally {
            this.setState((byte)1);
        }
    }

    public synchronized IlrManagedConnectionContext getManagedConnectionContext(IlrXUConnection conn) {
        return this.connectionContexts.get(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EngineManager getEngineManager(IlrXUConnection conn, boolean useUptodateRuleset) throws XUException {
        EngineManager engineMgr;
        if (this.isFinestLoggable) {
            this.logFinest(".getEngineManager", this.context);
            this.logFinest(".getEngineManager connectionContexts.size= " + this.connectionContexts.size(), this.context);
        }
        IlrManagedXUConnection ilrManagedXUConnection = this;
        synchronized (ilrManagedXUConnection) {
            engineMgr = conn.getEngineManager();
            if (engineMgr == null) {
                engineMgr = this.associateEngineManager(conn, useUptodateRuleset);
            }
        }
        return engineMgr;
    }

    private EngineManager associateEngineManager(IlrXUConnection conn, boolean useUptodateRuleset) throws IlrRulesetCacheException, XUException {
        IlrManagedConnectionContext spiCtx = this.connectionContexts.get(conn);
        if (spiCtx == null) {
            spiCtx = this.connectionContexts.add(conn);
        }
        if (this.isFinestLoggable) {
            this.logFinest(".associateEngineManager freeEngineManagers.size=" + this.freeEngineManagers.size(), this.context);
        }
        EngineManager engineMgr = null;
        for (int i = 0; i < this.freeEngineManagers.size(); ++i) {
            if (!this.freeEngineManagers.get(i).isUptodate()) continue;
            engineMgr = this.freeEngineManagers.get(i);
            break;
        }
        if (engineMgr == null) {
            engineMgr = this.createEngineManager(spiCtx, useUptodateRuleset);
            this.removeNotUptodateFreeEngineManagers();
        } else {
            if (this.isFinestLoggable) {
                this.logFinest(".associateEngineManager free uptodate engine manager found", spiCtx);
            }
            this.freeEngineManagers.remove(engineMgr);
            if (this.isFinestLoggable) {
                this.logFinest(".associateEngineManager removing all not uptodate engine managers", spiCtx);
            }
            this.removeNotUptodateFreeEngineManagers();
            if (this.isFinestLoggable) {
                this.logFinest(".associateEngineManager(): number of free engine managers:" + this.freeEngineManagers.size(), spiCtx);
            }
        }
        conn.setEngineManager(engineMgr);
        engineMgr.start(spiCtx);
        this.sendRulesetWarnings(engineMgr, spiCtx, true);
        return engineMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EngineManager createEngineManager(XURulesetImpl ruleset) throws XUException {
        IlrManagedXUConnection ilrManagedXUConnection;
        BaseEngineManager manager = null;
        try {
            ilrManagedXUConnection = this;
            synchronized (ilrManagedXUConnection) {
                if (this.dataConnectorFactory == null) {
                    this.dataConnectorFactory = ruleset.getDataConnectorFactory();
                }
            }
        }
        catch (DataConnectorException e) {
            throw new XUException(XUMessageCode.ERROR_CANNOT_CREATE_ENGINE_MANAGER, null, (Throwable)e);
        }
        IlrEngineType engineType = ruleset.getRulesetArchiveProperties().getEngineType();
        manager = engineType == IlrEngineType.DE ? this.createDEManager(ruleset) : this.createCREManager(ruleset, this.dataConnectorFactory);
        manager.addEngineManagerListener(this.factory.getPluginManager());
        manager.addChannelMessageListener(this.factory.getPluginManager());
        manager.addEngineListener(this.factory.getPluginManager());
        manager.setAuthorizationProvider(this.factory.getPluginManager().getAuthorizationProvider());
        if (this.factory.isRulesetUsageMonitorEnabled().booleanValue()) {
            manager.addEngineManagerListener(this.factory.getRulesetUsageMonitor());
        }
        ilrManagedXUConnection = this;
        synchronized (ilrManagedXUConnection) {
            if (ruleset == this.lastLoadedRuleset) {
                this.lastLoadedRuleset = null;
            }
        }
        return manager;
    }

    protected DEManager createDEManager(XURulesetImpl ruleset) {
        return new DEManager(this, ruleset);
    }

    protected CREManager createCREManager(XURulesetImpl ruleset, Object dconnFactory) throws XUException {
        IlrContext ctx = this.factory.getContextFactory().createContext(ruleset.getCRERuleset(), dconnFactory);
        DocumentBuilderPool docPool = this.factory.getCREDocumentBuilderPool();
        TransformerPool transformerPool = this.factory.getCRETransformerPool();
        return new CREManager(ruleset, ctx, this, docPool, transformerPool);
    }

    private EngineManager getEngineManagerFromPool(XURulesetImpl ruleset) {
        for (int i = 0; i < this.freeEngineManagers.size(); ++i) {
            EngineManager engine = this.freeEngineManagers.get(i);
            if (engine.getRuleset() != ruleset) continue;
            this.freeEngineManagers.remove(i);
            return engine;
        }
        return null;
    }

    private synchronized EngineManager createEngineManager(IlrManagedConnectionContext xuCtx, boolean useUptodateRuleset) throws IlrRulesetCacheException, XUException {
        XURulesetImpl ruleset;
        if (this.isFinestLoggable) {
            this.logFinest(".createEngineManager(): useUptodateRuleset =" + useUptodateRuleset, xuCtx);
        }
        Persistence persistence = this.getPersistence();
        IlrRulesetProvider rulesetProvider = this.getRulesetProvider();
        IlrRulesetArchiveInformationBase archive = null;
        boolean uptodate = true;
        try {
            boolean block = useUptodateRuleset || this.factory.isAsynchronousRulesetParsing() == false;
            archive = persistence.getRulesetArchiveInformation(this.rulesetPath, this.xomClassLoader, xuCtx, block);
            ruleset = rulesetProvider.getRuleset((IlrXURulesetArchiveInformation)archive, xuCtx, block, this);
        }
        catch (IlrRulesetAlreadyParsingException e) {
            IlrXURulesetArchiveInformation deprecatedArchive;
            ruleset = archive != null ? rulesetProvider.getDeprecatedRuleset(archive.getCanonicalPath().toString(), archive.getXOMClassLoader()) : null;
            if (ruleset == null && (deprecatedArchive = persistence.getDeprecatedRulesetArchiveInformation(this.rulesetPath, this.xomClassLoader)) != null && (ruleset = (XURulesetImpl)rulesetProvider.getCache().getRuleset(deprecatedArchive.getCanonicalPath().toString(), deprecatedArchive.getXOMClassLoader())) == null) {
                ruleset = (XURulesetImpl)rulesetProvider.getCache().getDeprecatedRuleset(deprecatedArchive.getCanonicalPath().toString(), deprecatedArchive.getXOMClassLoader());
            }
            if (ruleset == null) {
                archive = persistence.getRulesetArchiveInformation(this.rulesetPath, this.xomClassLoader, xuCtx, true);
                ruleset = rulesetProvider.getRuleset((IlrXURulesetArchiveInformation)archive, xuCtx, true, this);
            }
            uptodate = false;
        }
        IlrProfilingRulesetEvent event = this.profilingHelper.startRulesetMeasure(2, ruleset.getArchive(), xuCtx);
        EngineManager engine = this.getEngineManagerFromPool(ruleset);
        if (engine == null) {
            engine = this.createEngineManager(ruleset);
            engine.setUptodate(uptodate);
        }
        this.profilingHelper.stopRulesetMeasure(event);
        this.profilingHelper.sendRulesetEvent(event);
        return engine;
    }

    protected void sendRulesetWarnings(EngineManager mgr, IlrXUContext ctx, boolean log) {
        String canonicalPath = mgr.getRuleset().getCanonicalRulesetPath();
        Collection<String> warns = mgr.getRuleset().getWarnings();
        if (warns != null) {
            for (String warn : warns) {
                this.logger.warning(XUMessageCode.WARNING_RULESET_PARSING, null, new Object[]{canonicalPath, warn}, canonicalPath, ctx, false);
            }
        }
        if (mgr instanceof CREManager) {
            CREManager creMgr = (CREManager)mgr;
            IlrCRERulesetArchive creArchive = (IlrCRERulesetArchive)creMgr.getRuleset().getArchive().getRESRulesetArchive();
            IlrRulesetArchive archive = creArchive.getRulesetArchive();
            int major = IlrInternalRulesetArchiveHelper.getMajorVersion((IlrRulesetArchive)archive);
            int minor = IlrInternalRulesetArchiveHelper.getMinorVersion((IlrRulesetArchive)archive);
            int jrulesMajor = 8;
            int jrulesMinor = 7;
            if (major > jrulesMajor || major == jrulesMajor && minor > jrulesMinor) {
                this.logger.warning(XUMessageCode.WARNING_NEWER_RULESET_ARCHIVE_VERSION, null, new Object[]{jrulesMajor + "." + jrulesMinor, major + "." + minor}, canonicalPath, ctx, false);
            }
        }
    }

    @Override
    public final void workEnded(RulesetParsingWork work) {
        if (work.getState() == 2) {
            this.lastLoadedRuleset = work.getRuleset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized boolean isRulesetUptodate(IlrXUConnection conn) throws XUException {
        this.setState((byte)3);
        try {
            boolean bl = this.getEngineManager(conn, false).isUptodate();
            return bl;
        }
        finally {
            this.setState((byte)1);
        }
    }

    private void logFinest(String msg, IlrXUContext ctx) {
        this.logger.finest(this.getClass().getName() + msg, null, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized List<Object> engineToNodes(IlrXUConnection conn, List<Object> xom) throws XUException {
        EngineManager engineManager = this.getEngineManager(conn, false);
        if (engineManager instanceof DEManager) {
            this.setState((byte)3);
            try {
                List<Object> list = ((DEManager)engineManager).toNodes(xom);
                return list;
            }
            finally {
                this.setState((byte)1);
            }
        }
        throw new XUException(XUMessageCode.ERROR_ENGINE_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized List<Object> engineNodesToXOMObjects(IlrXUConnection conn, List<Object> nodes) throws XUException {
        EngineManager engineManager = this.getEngineManager(conn, false);
        if (engineManager instanceof DEManager) {
            this.setState((byte)3);
            try {
                List<Object> list = ((DEManager)engineManager).nodesToXOMObjects(nodes);
                return list;
            }
            finally {
                this.setState((byte)1);
            }
        }
        throw new XUException(XUMessageCode.ERROR_ENGINE_TYPE);
    }
}

