/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

import ilog.rules.util.IlrAuthorMap;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class IlrAuthorWriter
extends FilterWriter {
    List entries = new ArrayList();
    int counter;
    int authorStart;
    Object currentAuthor;

    public IlrAuthorWriter(Writer writer) {
        super(writer);
        this.reset();
    }

    public void reset() {
        this.entries = new ArrayList();
        this.counter = 0;
        this.currentAuthor = null;
    }

    public void resetAuthor() {
        if (this.currentAuthor != null && this.counter > 0) {
            this.entries.add(new Entry(this.currentAuthor, this.authorStart, this.counter));
        }
        this.currentAuthor = null;
    }

    public void setAuthor(Object author) {
        this.resetAuthor();
        this.authorStart = this.counter;
        this.currentAuthor = author;
    }

    public IlrAuthorMap getAuthorMap() {
        return new IlrAuthorMap(this.entries);
    }

    @Override
    public void write(int c) throws IOException {
        int lc = this.counter + 1;
        this.out.write(c);
        this.counter = lc;
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        int lc = this.counter + cbuf.length;
        this.out.write(cbuf);
        this.counter = lc;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int lc = this.counter + len;
        this.out.write(cbuf, off, len);
        this.counter = lc;
    }

    @Override
    public void write(String str) throws IOException {
        int lc = this.counter + str.length();
        this.out.write(str);
        this.counter = lc;
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        int lc = this.counter + len;
        this.out.write(str, off, len);
        this.counter = lc;
    }

    static class Entry {
        Object author;
        int start;
        int end;

        Entry(Object author, int start, int end) {
            this.author = author;
            this.start = start;
            this.end = end;
        }
    }
}

