/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class IlrBase64DecoderStream
extends FilterInputStream {
    private byte[] buffer;
    private int bufsize;
    private int index;
    private byte[] decode_buffer = new byte[4];
    private static final char[] pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final byte[] pem_convert_array = new byte[256];

    public IlrBase64DecoderStream(InputStream inputstream) {
        super(inputstream);
        this.buffer = new byte[3];
    }

    @Override
    public int read() throws IOException {
        if (this.index >= this.bufsize) {
            this.decode();
            if (this.bufsize == 0) {
                return -1;
            }
            this.index = 0;
        }
        return this.buffer[this.index++] & 0xFF;
    }

    @Override
    public int read(byte[] abyte0, int i, int j) throws IOException {
        int k;
        try {
            for (k = 0; k < j; ++k) {
                int l = this.read();
                if (l == -1) {
                    if (k == 0) {
                        k = -1;
                    }
                    break;
                }
                abyte0[i + k] = (byte)l;
            }
        }
        catch (IOException _ex) {
            k = -1;
        }
        return k;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int available() throws IOException {
        return this.in.available() * 3 / 4 + (this.bufsize - this.index);
    }

    private void decode() throws IOException {
        int l;
        int i;
        this.bufsize = 0;
        do {
            if ((i = this.in.read()) != -1) continue;
            return;
        } while (i == 10 || i == 13);
        this.decode_buffer[0] = (byte)i;
        int j = 3;
        int k = 1;
        while ((l = this.in.read(this.decode_buffer, k, j)) != j) {
            if (l == -1) {
                throw new IOException("Error in encoded stream");
            }
            j -= l;
            k += l;
        }
        byte byte0 = pem_convert_array[this.decode_buffer[0] & 0xFF];
        byte byte2 = pem_convert_array[this.decode_buffer[1] & 0xFF];
        this.buffer[this.bufsize++] = (byte)(byte0 << 2 & 0xFC | byte2 >>> 4 & 3);
        if (this.decode_buffer[2] == 61) {
            return;
        }
        byte0 = byte2;
        byte2 = pem_convert_array[this.decode_buffer[2] & 0xFF];
        this.buffer[this.bufsize++] = (byte)(byte0 << 4 & 0xF0 | byte2 >>> 2 & 0xF);
        if (this.decode_buffer[3] == 61) {
            return;
        }
        byte byte1 = byte2;
        byte2 = pem_convert_array[this.decode_buffer[3] & 0xFF];
        this.buffer[this.bufsize++] = (byte)(byte1 << 6 & 0xC0 | byte2 & 0x3F);
    }

    public static byte[] decode(byte[] abyte0) {
        int i = abyte0.length / 4 * 3;
        if (i == 0) {
            return abyte0;
        }
        if (abyte0[abyte0.length - 1] == 61) {
            --i;
            if (abyte0[abyte0.length - 2] == 61) {
                --i;
            }
        }
        byte[] abyte1 = new byte[i];
        int k = 0;
        int l = 0;
        for (int j = abyte0.length; j > 0; j -= 4) {
            byte byte0 = pem_convert_array[abyte0[k++] & 0xFF];
            byte byte1 = pem_convert_array[abyte0[k++] & 0xFF];
            abyte1[l++] = (byte)(byte0 << 2 & 0xFC | byte1 >>> 4 & 3);
            if (abyte0[k] == 61) {
                return abyte1;
            }
            byte0 = byte1;
            byte1 = pem_convert_array[abyte0[k++] & 0xFF];
            abyte1[l++] = (byte)(byte0 << 4 & 0xF0 | byte1 >>> 2 & 0xF);
            if (abyte0[k] == 61) {
                return abyte1;
            }
            byte0 = byte1;
            byte1 = pem_convert_array[abyte0[k++] & 0xFF];
            abyte1[l++] = (byte)(byte0 << 6 & 0xC0 | byte1 & 0x3F);
        }
        return abyte1;
    }

    static {
        for (int i = 0; i < 255; ++i) {
            IlrBase64DecoderStream.pem_convert_array[i] = -1;
        }
        for (int j = 0; j < pem_array.length; ++j) {
            IlrBase64DecoderStream.pem_convert_array[IlrBase64DecoderStream.pem_array[j]] = (byte)j;
        }
    }
}

