/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class IlrBase64EncoderStream
extends FilterOutputStream {
    private byte[] buffer = new byte[3];
    private int bufsize;
    private int count;
    private int bytesPerLine;
    private static final char[] pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    public IlrBase64EncoderStream(OutputStream outputstream, int i) {
        super(outputstream);
        this.bytesPerLine = i;
    }

    public IlrBase64EncoderStream(OutputStream outputstream) {
        this(outputstream, 76);
    }

    @Override
    public void write(byte[] abyte0, int i, int j) throws IOException {
        for (int k = 0; k < j; ++k) {
            this.write(abyte0[i + k]);
        }
    }

    @Override
    public void write(byte[] abyte0) throws IOException {
        this.write(abyte0, 0, abyte0.length);
    }

    @Override
    public void write(int i) throws IOException {
        this.buffer[this.bufsize++] = (byte)i;
        if (this.bufsize == 3) {
            this.encode();
            this.bufsize = 0;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.bufsize > 0) {
            this.encode();
            this.bufsize = 0;
        }
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    private void encode() throws IOException {
        if (this.count + 4 > this.bytesPerLine) {
            this.out.write(13);
            this.out.write(10);
            this.count = 0;
        }
        if (this.bufsize == 1) {
            byte byte0 = this.buffer[0];
            int i = 0;
            this.out.write(pem_array[byte0 >>> 2 & 0x3F]);
            this.out.write(pem_array[(byte0 << 4 & 0x30) + (i >>> 4 & 0xF)]);
            this.out.write(61);
            this.out.write(61);
        } else if (this.bufsize == 2) {
            byte byte1 = this.buffer[0];
            byte byte3 = this.buffer[1];
            int j = 0;
            this.out.write(pem_array[byte1 >>> 2 & 0x3F]);
            this.out.write(pem_array[(byte1 << 4 & 0x30) + (byte3 >>> 4 & 0xF)]);
            this.out.write(pem_array[(byte3 << 2 & 0x3C) + (j >>> 6 & 3)]);
            this.out.write(61);
        } else {
            byte byte2 = this.buffer[0];
            byte byte4 = this.buffer[1];
            byte byte5 = this.buffer[2];
            this.out.write(pem_array[byte2 >>> 2 & 0x3F]);
            this.out.write(pem_array[(byte2 << 4 & 0x30) + (byte4 >>> 4 & 0xF)]);
            this.out.write(pem_array[(byte4 << 2 & 0x3C) + (byte5 >>> 6 & 3)]);
            this.out.write(pem_array[byte5 & 0x3F]);
        }
        this.count += 4;
    }

    public static byte[] encode(byte[] abyte0) {
        if (abyte0.length == 0) {
            return abyte0;
        }
        byte[] abyte1 = new byte[(abyte0.length + 2) / 3 * 4];
        int i = 0;
        int j = 0;
        for (int k = abyte0.length; k > 0; k -= 3) {
            if (k == 1) {
                byte byte0 = abyte0[i++];
                int l = 0;
                abyte1[j++] = (byte)pem_array[byte0 >>> 2 & 0x3F];
                abyte1[j++] = (byte)pem_array[(byte0 << 4 & 0x30) + (l >>> 4 & 0xF)];
                abyte1[j++] = 61;
                abyte1[j++] = 61;
                continue;
            }
            if (k == 2) {
                byte byte1 = abyte0[i++];
                byte byte3 = abyte0[i++];
                int i1 = 0;
                abyte1[j++] = (byte)pem_array[byte1 >>> 2 & 0x3F];
                abyte1[j++] = (byte)pem_array[(byte1 << 4 & 0x30) + (byte3 >>> 4 & 0xF)];
                abyte1[j++] = (byte)pem_array[(byte3 << 2 & 0x3C) + (i1 >>> 6 & 3)];
                abyte1[j++] = 61;
                continue;
            }
            byte byte2 = abyte0[i++];
            byte byte4 = abyte0[i++];
            byte byte5 = abyte0[i++];
            abyte1[j++] = (byte)pem_array[byte2 >>> 2 & 0x3F];
            abyte1[j++] = (byte)pem_array[(byte2 << 4 & 0x30) + (byte4 >>> 4 & 0xF)];
            abyte1[j++] = (byte)pem_array[(byte4 << 2 & 0x3C) + (byte5 >>> 6 & 3)];
            abyte1[j++] = (byte)pem_array[byte5 & 0x3F];
        }
        return abyte1;
    }

    public static void encode(byte[] abyte0, Appendable target) throws IOException {
        if (abyte0.length == 0) {
            return;
        }
        int i = 0;
        boolean j = false;
        for (int k = abyte0.length; k > 0; k -= 3) {
            if (k == 1) {
                byte byte0 = abyte0[i++];
                int l = 0;
                target.append(pem_array[byte0 >>> 2 & 0x3F]);
                target.append(pem_array[(byte0 << 4 & 0x30) + (l >>> 4 & 0xF)]);
                target.append('=');
                target.append('=');
                continue;
            }
            if (k == 2) {
                byte byte1 = abyte0[i++];
                byte byte3 = abyte0[i++];
                int i1 = 0;
                target.append(pem_array[byte1 >>> 2 & 0x3F]);
                target.append(pem_array[(byte1 << 4 & 0x30) + (byte3 >>> 4 & 0xF)]);
                target.append(pem_array[(byte3 << 2 & 0x3C) + (i1 >>> 6 & 3)]);
                target.append('=');
                continue;
            }
            byte byte2 = abyte0[i++];
            byte byte4 = abyte0[i++];
            byte byte5 = abyte0[i++];
            target.append(pem_array[byte2 >>> 2 & 0x3F]);
            target.append(pem_array[(byte2 << 4 & 0x30) + (byte4 >>> 4 & 0xF)]);
            target.append(pem_array[(byte4 << 2 & 0x3C) + (byte5 >>> 6 & 3)]);
            target.append(pem_array[byte5 & 0x3F]);
        }
    }
}

