/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

import ilog.rules.util.IlrBinaryClassLoaderHeuristic;
import java.net.URL;
import java.security.SecureClassLoader;

public final class IlrBinaryClassLoader
extends SecureClassLoader {
    private ClassLoader subsidiary;
    private IlrBinaryClassLoaderHeuristic heuristic;

    public IlrBinaryClassLoader(ClassLoader subsidiary) {
        assert (subsidiary != null) : "Subsidiary classloader couldn't be null";
        this.subsidiary = subsidiary;
    }

    public IlrBinaryClassLoader(ClassLoader parent, ClassLoader subsidiary) {
        super(parent);
        assert (subsidiary != null) : "Subsidiary classloader couldn't be null";
        this.subsidiary = subsidiary;
    }

    public static boolean isParentOf(ClassLoader parent, ClassLoader child) {
        for (ClassLoader p = child; p != null; p = p.getParent()) {
            if (!p.equals(parent)) continue;
            return true;
        }
        return false;
    }

    public IlrBinaryClassLoaderHeuristic getHeuristic() {
        return this.heuristic;
    }

    public void setHeuristic(IlrBinaryClassLoaderHeuristic heuristic) {
        this.heuristic = heuristic;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.subsidiary.loadClass(name);
    }

    @Override
    protected URL findResource(String resName) {
        return this.subsidiary.getResource(resName);
    }
}

