/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

public class IlrCancellable {
    protected Listener cancelListener;

    public IlrCancellable() {
    }

    public IlrCancellable(Listener listener) {
        this.cancelListener = listener;
    }

    public void checkCancelled() throws OperationCancelledException {
        if (this.cancelListener != null && this.cancelListener.isCancelled()) {
            throw this.makeOperationCancelledException();
        }
    }

    protected OperationCancelledException makeOperationCancelledException() {
        if (this.cancelListener instanceof ExplainingListener) {
            String reason = ((ExplainingListener)this.cancelListener).getCancelReason();
            return new OperationCancelledException(reason);
        }
        return new OperationCancelledException();
    }

    public static class OperationCancelledException
    extends RuntimeException {
        public OperationCancelledException() {
        }

        public OperationCancelledException(String reason) {
            super(reason);
        }
    }

    public static interface ExplainingListener
    extends Listener {
        public String getCancelReason();
    }

    public static interface Listener {
        public boolean isCancelled();
    }
}

