/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

import ilog.rules.util.IlrFileUtil;
import ilog.rules.util.IlrURI;
import ilog.rules.util.IlrURIUtils;
import ilog.rules.util.prefs.IlrMessages;
import java.io.File;

public class IlrFile
extends File
implements IlrURI {
    public static final String PROTOCOL = "file";
    private String rootId;

    public IlrFile(String pathname) {
        super(IlrFileUtil.ensureFileSeparator(IlrURIUtils.extractPathname(pathname)));
        this.rootId = IlrURIUtils.extractRootId(pathname);
    }

    public IlrFile(String parent, String child) {
        super(IlrFileUtil.ensureFileSeparator(parent), IlrFileUtil.ensureFileSeparator(child));
    }

    public IlrFile(File parent, String child) {
        this(IlrFileUtil.ensureFileSeparator(parent.getPath()), IlrFileUtil.ensureFileSeparator(child));
    }

    public IlrFile(File file) {
        super(IlrFileUtil.ensureFileSeparator(file.getPath()));
    }

    public IlrFile(String rootId, File file) {
        super(IlrFileUtil.ensureFileSeparator(file.getPath()));
        this.setRootId(rootId);
    }

    protected Object clone() throws CloneNotSupportedException {
        return new IlrFile(this.rootId, this.getPath());
    }

    @Override
    public void setRootId(String rootId) {
        this.rootId = rootId;
    }

    @Override
    public String getRootId() {
        return this.rootId;
    }

    @Override
    public boolean isFiltered() {
        return false;
    }

    @Override
    public File getAbsoluteFile() {
        if (this.rootId != null) {
            String msg = "rootID != null [" + this.rootId + "]: Cannot resolve absolute path\n";
            msg = msg + "relative path is " + this.getPath() + "\n";
            msg = msg + "Hints: use the IlrRepository.resolveFile method if applicable.";
            throw new UnsupportedOperationException(msg);
        }
        return super.getAbsoluteFile();
    }

    @Override
    public String getAbsolutePath() {
        if (this.rootId != null) {
            String msg = "rootID != null [" + this.rootId + "]: Cannot resolve absolute path\n";
            msg = msg + "relative path is " + this.getPath() + "\n";
            msg = msg + "Hints: use the IlrRepository.resolveFile method if applicable.";
            throw new UnsupportedOperationException(msg);
        }
        return super.getAbsolutePath();
    }

    @Override
    public String getDisplayRootId() {
        return IlrMessages.getMessage(this.rootId);
    }

    @Override
    public String getDisplayPath() {
        return IlrURIUtils.makeRelativeDisplayPathName(this.getPath(), this.rootId);
    }

    @Override
    public String getType() {
        return PROTOCOL;
    }

    public IlrFile[] listIlrFiles() {
        IlrFile[] ilrfiles = null;
        File[] files = this.listFiles();
        if (files != null) {
            ilrfiles = new IlrFile[files.length];
            for (int i = 0; i < files.length; ++i) {
                ilrfiles[i] = new IlrFile(this.getRootId(), files[i]);
            }
        }
        return ilrfiles;
    }

    public static IlrFile[] fileList(File[] files) {
        IlrFile[] ilrfiles = null;
        if (files != null) {
            ilrfiles = new IlrFile[files.length];
            for (int i = 0; i < files.length; ++i) {
                ilrfiles[i] = new IlrFile(files[i]);
            }
        }
        return ilrfiles;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IlrFile) {
            IlrFile file = (IlrFile)obj;
            if (this.rootId != null) {
                return this.rootId.equals(file.getRootId()) && super.equals(obj);
            }
        }
        return super.equals(obj);
    }

    @Override
    public String toString() {
        if (this.rootId != null) {
            return IlrURIUtils.makeRelativePathName(this.getPath(), this.rootId);
        }
        return this.getPath();
    }
}

