/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

public class IlrPackageUtilities {
    public static String findPackageName(String name) {
        int lastIndexOf = IlrPackageUtilities.getLastDotIndex(name);
        if (lastIndexOf == -1) {
            return "";
        }
        return new String(name.substring(0, lastIndexOf));
    }

    public static String findShortName(String name) {
        int lastIndexOf = IlrPackageUtilities.getLastDotIndex(name);
        if (lastIndexOf == -1) {
            return name;
        }
        return new String(name.substring(lastIndexOf + 1));
    }

    public static String computeFQName(String shortName, String pkgName) {
        if (pkgName == null || pkgName.length() == 0) {
            return shortName;
        }
        return pkgName + '.' + shortName;
    }

    public static int getLastDotIndex(String fullyQualifiedName) {
        return fullyQualifiedName == null ? -1 : fullyQualifiedName.lastIndexOf(46);
    }

    public static String[] getSplitName(String fullyQualifiedName) {
        String[] result = new String[2];
        int index = IlrPackageUtilities.getLastDotIndex(fullyQualifiedName);
        if (index > 0) {
            result[0] = fullyQualifiedName.substring(0, index);
            result[1] = fullyQualifiedName.substring(index + 1);
        } else {
            result[1] = fullyQualifiedName;
        }
        return result;
    }

    public static String getName(String fullyQualifiedName) {
        int index = IlrPackageUtilities.getLastDotIndex(fullyQualifiedName);
        if (index > 0) {
            return fullyQualifiedName.substring(index + 1);
        }
        return fullyQualifiedName;
    }

    public static String changeNestedNativeClassname(String fqn) {
        char[] chars = fqn.toCharArray();
        boolean modified = false;
        for (int i = chars.length - 1; i >= 0 && chars[i] != '.'; --i) {
            if (chars[i] != '$') continue;
            chars[i] = 46;
            modified = true;
        }
        if (!modified) {
            return fqn;
        }
        return new String(chars);
    }
}

