/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public final class IlrSecureUtil {
    private IlrSecureUtil() {
    }

    public static boolean isEngineInDebug() {
        String eclipseDebugger = System.getProperty("IlrEclipseDebugger");
        String debugger = System.getProperty("IlrDebugger");
        boolean debugMode = eclipseDebugger != null && eclipseDebugger.equals("true") || debugger != null && debugger.equals("true");
        return debugMode;
    }

    public static String getSystemProperty(final String propname) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(propname);
            }
        });
    }

    public static String getSystemPropertyWhenGranted(final String propname) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                try {
                    SecurityManager manager = System.getSecurityManager();
                    if (manager != null) {
                        manager.checkPropertyAccess(propname);
                    }
                    return System.getProperty(propname);
                }
                catch (SecurityException ex) {
                    return null;
                }
            }
        });
    }

    public static FileInputStream newFileInputStream(final String file) throws FileNotFoundException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                @Override
                public FileInputStream run() throws Exception {
                    return new FileInputStream(file);
                }
            });
        }
        catch (PrivilegedActionException ex) {
            throw (FileNotFoundException)ex.getException();
        }
    }

    public static FileInputStream newFileInputStream(final File file) throws FileNotFoundException {
        try {
            return (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new FileInputStream(file);
                }
            });
        }
        catch (PrivilegedActionException ex) {
            throw (FileNotFoundException)ex.getException();
        }
    }

    public static FileWriter newFileWriter(final File file) throws IOException {
        try {
            return (FileWriter)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new FileWriter(file);
                }
            });
        }
        catch (PrivilegedActionException ex) {
            throw (IOException)ex.getException();
        }
    }
}

