/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class IlrUnicodeWriter
extends Writer {
    private static final String BACKSLASH_U = "\\u";
    private static final int BACKSLASH_U_LENGTH = 2;
    private OutputStream out;

    public IlrUnicodeWriter(OutputStream out) {
        this.out = out;
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out == null) {
                return;
            }
            this.flush();
            this.out.close();
            this.out = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            int end = off + len;
            int size = 0;
            StringBuffer sbuf = new StringBuffer();
            for (int index = off; index < end; ++index) {
                if (cbuf[index] > '\u00ff') {
                    sbuf.append(BACKSLASH_U);
                    String hex = IlrUnicodeWriter.charToHex(cbuf[index]);
                    sbuf.append(hex);
                    size += 2 + hex.length();
                    continue;
                }
                sbuf.append(cbuf[index]);
                ++size;
            }
            int length = sbuf.length();
            byte[] byteArray = new byte[length];
            for (int cbufIndex = 0; cbufIndex < length; ++cbufIndex) {
                byteArray[cbufIndex] = (byte)sbuf.charAt(cbufIndex);
            }
            this.out.write(byteArray, 0, size);
        }
    }

    public static String byteToHex(byte b) {
        char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] array = new char[]{hexDigit[b >> 4 & 0xF], hexDigit[b & 0xF]};
        return new String(array);
    }

    public static String charToHex(char c) {
        byte hi = (byte)(c >>> 8);
        byte lo = (byte)(c & 0xFF);
        return IlrUnicodeWriter.byteToHex(hi) + IlrUnicodeWriter.byteToHex(lo);
    }
}

