/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util.engine;

public abstract class IlrPlatformNameBuilder {
    public static String makeClassName(String name) {
        StringBuilder builder = new StringBuilder();
        int length = name.length();
        builder.append('C');
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            String hex = Integer.toHexString(c);
            builder.append(hex);
        }
        return builder.toString();
    }

    public static String makeMethodName(String name) {
        return IlrPlatformNameBuilder.makePlatformName(name);
    }

    public static String makePlatformName(String name) {
        StringBuilder builder = new StringBuilder();
        int length = name.length();
        char c = name.charAt(0);
        IlrPlatformNameBuilder.addPlatformNameStart(c, builder);
        for (int i = 1; i < length; ++i) {
            c = name.charAt(i);
            IlrPlatformNameBuilder.addPlatformNamePart(c, builder);
        }
        return builder.toString();
    }

    public static void addPlatformNameStart(char c, StringBuilder builder) {
        if (Character.isJavaIdentifierStart(c)) {
            builder.append(c);
        } else {
            builder.append('_');
            builder.append(Integer.toHexString(c));
        }
    }

    public static void addPlatformNamePart(char c, StringBuilder builder) {
        if (Character.isJavaIdentifierPart(c)) {
            builder.append(c);
        } else {
            builder.append('_');
            builder.append(Integer.toHexString(c));
        }
    }
}

