/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util.issue;

import ilog.rules.util.issue.IlrError;
import ilog.rules.util.issue.IlrErrorException;
import ilog.rules.util.issue.IlrFormattedMessage;
import ilog.rules.util.issue.IlrIssue;
import ilog.rules.util.issue.IlrIssueHandler;
import ilog.rules.util.issue.IlrWarning;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class IlrDefaultIssueHandler
implements IlrIssueHandler {
    protected List<IlrError> errors = new ArrayList<IlrError>();
    protected List<IlrWarning> warnings = new ArrayList<IlrWarning>();

    @Override
    public void add(IlrError error) {
        this.errors.add(error);
    }

    @Override
    public void add(IlrWarning warning) {
        this.warnings.add(warning);
    }

    @Override
    public Collection<IlrError> getErrors() {
        return Collections.unmodifiableCollection(this.errors);
    }

    @Override
    public Collection<IlrWarning> getWarnings() {
        return Collections.unmodifiableCollection(this.warnings);
    }

    @Override
    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    @Override
    public void clear() {
        this.errors.clear();
        this.warnings.clear();
    }

    @Override
    public void throwException() {
        throw new IlrErrorException(this.errors, this.warnings);
    }

    public static void writeIssues(PrintStream stream, Collection<? extends IlrIssue> issues) {
        if (issues != null && !issues.isEmpty()) {
            IlrFormattedMessage lastLocation = null;
            for (IlrIssue ilrIssue : issues) {
                IlrFormattedMessage currentLocation = ilrIssue.getLocation();
                if (currentLocation != null && currentLocation != lastLocation) {
                    stream.println(currentLocation.getMessage());
                }
                lastLocation = currentLocation;
                if (currentLocation != null) {
                    stream.print("  ");
                }
                stream.println(ilrIssue);
            }
        }
    }
}

