/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util.issue;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class IlrFormattedMessage {
    protected String baseName;
    protected String id;

    public IlrFormattedMessage(String baseName, String id) {
        this.baseName = baseName;
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getMessage() {
        return this.getMessage(Locale.getDefault());
    }

    protected String getResourceMessage(Locale locale) {
        if (this.baseName.length() != 0) {
            ResourceBundle bundle = ResourceBundle.getBundle(this.baseName, locale, this.getClass().getClassLoader());
            return bundle.getString(this.id);
        }
        return "{0}";
    }

    protected String getResourceMessage(Locale locale, ClassLoader loader) {
        if (this.baseName.length() != 0) {
            ResourceBundle bundle = ResourceBundle.getBundle(this.baseName, locale, loader);
            return bundle.getString(this.id);
        }
        return "{0}";
    }

    public String getMessageId() {
        if (this.baseName.length() != 0 && !this.id.startsWith("GBR") && !this.id.startsWith("CWM")) {
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(this.baseName);
                return bundle.getString(this.id + "_msgid");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return this.id;
    }

    public abstract String getMessage(Locale var1);

    public abstract String getMessage(Locale var1, ClassLoader var2);
}

