/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util.prefs;

import ilog.rules.util.prefs.IlrPropertyBundle;
import ilog.rules.util.prefs.IlrPropertyManager;

public class IlrPreferences
extends IlrPropertyManager {
    private static IlrPreferences preferences;

    public static IlrPreferences getPreferences() {
        if (preferences == null) {
            IlrPreferences.init();
        }
        return preferences;
    }

    private static synchronized void init() {
        if (preferences == null) {
            preferences = new IlrPreferences();
            preferences.setPrefixes(new String[]{"ilog.rules", ""});
            preferences.setSuffixes(new String[]{""});
        }
    }

    protected IlrPreferences() {
    }

    @Override
    protected String getBaseClassName() {
        return "preferences";
    }

    public static String getString(String key) {
        return IlrPreferences.getString((IlrPropertyBundle)null, key);
    }

    public static String getString(String key, String defaultString) {
        return IlrPreferences.getString(null, key, defaultString);
    }

    public static String getString(IlrPropertyBundle bundle, String key) {
        return IlrPreferences.getPreferenceString(bundle, key);
    }

    public static String getString(IlrPropertyBundle bundle, String key, String defaultString) {
        String res = IlrPreferences.getString(bundle, key);
        if (res == null) {
            return defaultString;
        }
        return res;
    }

    public static String[] getStringArray(String key) {
        return IlrPreferences.getStringArray((IlrPropertyBundle)null, key);
    }

    public static String[] getStringArray(String key, String separators, String prefix) {
        String ss = IlrPreferences.getPreferenceString(null, key);
        if (ss == null) {
            return null;
        }
        return IlrPropertyBundle.tokenize(ss, separators, prefix);
    }

    public static String[] getStringArray(IlrPropertyBundle bundle, String key) {
        String ss = IlrPreferences.getPreferenceString(bundle, key);
        if (ss == null) {
            return null;
        }
        return IlrPropertyBundle.tokenize(ss);
    }

    public static String[] getStringArray(String key, String prefix) {
        return IlrPreferences.getStringArray((IlrPropertyBundle)null, key, prefix);
    }

    public static String[] getStringArray(IlrPropertyBundle bundle, String key, String prefix) {
        String ss = IlrPreferences.getPreferenceString(bundle, key);
        if (ss == null) {
            return null;
        }
        return IlrPropertyBundle.tokenize(ss, " \t\n\r\f,;", prefix);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        return IlrPreferences.getBoolean(null, key, defaultValue);
    }

    public static boolean getBoolean(IlrPropertyBundle bundle, String key, boolean defaultValue) {
        String s = IlrPreferences.getPreferenceString(bundle, key);
        if (s == null) {
            return defaultValue;
        }
        Boolean result = Boolean.valueOf(s);
        return result;
    }

    public static char getChar(String key, char defaultValue) {
        return IlrPreferences.getChar(null, key, defaultValue);
    }

    public static char getChar(IlrPropertyBundle bundle, String key, char defaultValue) {
        String s = IlrPreferences.getPreferenceString(bundle, key);
        if (s == null || s.length() == 0) {
            return defaultValue;
        }
        return s.charAt(0);
    }

    public static int getInt(String key, int defaultValue) {
        return IlrPreferences.getInt(null, key, defaultValue);
    }

    public static int getInt(IlrPropertyBundle bundle, String key, int defaultValue) {
        String s = IlrPreferences.getPreferenceString(bundle, key);
        if (s == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static float getFloat(String key, float defaultValue) {
        return IlrPreferences.getFloat(null, key, defaultValue);
    }

    public static float getFloat(IlrPropertyBundle bundle, String key, float defaultValue) {
        String s = IlrPreferences.getPreferences().getValue(key);
        if (s == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    protected static String getPreferenceString(IlrPropertyBundle bundle, String key) {
        if (bundle == null) {
            return IlrPreferences.getPreferences().getValue(key);
        }
        return bundle.getString(key);
    }
}

