/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util.prefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class IlrPropertyBundle {
    public static final String EXTENSION = ".properties";
    protected Hashtable properties;
    private String name;
    private String namep;

    protected IlrPropertyBundle(String name) {
        this.name = name;
        this.namep = name + ".";
        this.properties = new Hashtable();
    }

    public String getName() {
        return this.name;
    }

    public boolean containsKey(String key) {
        if (key == null) {
            return false;
        }
        if (this.name.length() > 0 && key.startsWith(this.namep)) {
            key = key.substring(this.namep.length());
        }
        return this.properties.containsKey(key);
    }

    String getRawString(String key) {
        if (key == null) {
            return null;
        }
        if (this.name.length() > 0 && key.startsWith(this.namep)) {
            key = key.substring(this.namep.length());
        }
        return (String)this.properties.get(key);
    }

    public String getString(String key, String defaultValue) {
        String res = this.getRawString(key);
        if (res != null) {
            return IlrPropertyBundle.cleanName(res);
        }
        return defaultValue;
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public void reset() {
        this.properties.clear();
    }

    public void addProperties(ResourceBundle bundle) {
        if (bundle != null) {
            Enumeration<String> it = bundle.getKeys();
            while (it.hasMoreElements()) {
                String key = it.nextElement();
                this.setProperty(key, bundle.getString(key));
            }
        }
    }

    public void addProperties(Properties props) {
        if (props != null) {
            Enumeration<Object> it = props.keys();
            while (it.hasMoreElements()) {
                String key = (String)it.nextElement();
                this.setProperty(key, (String)props.get(key));
            }
        }
    }

    public void addProperties(File file) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        this.addProperties(new PropertyResourceBundle(stream));
    }

    public void setProperty(String key, String value) {
        if (key != null) {
            this.properties.put(key, value);
        }
    }

    public ResourceBundle getResourceBundle() {
        return new Bundle();
    }

    public static String cleanName(String name) {
        int start;
        if (name == null || name.length() == 0) {
            return null;
        }
        int end = name.length() - 1;
        for (start = 0; start <= end && name.charAt(start) == ' '; ++start) {
        }
        while (end > start && name.charAt(end) == ' ') {
            --end;
        }
        if (start == 0 && end == name.length() - 1) {
            return name;
        }
        String newname = name.substring(start, end + 1);
        if (newname.length() == 0) {
            return null;
        }
        return newname;
    }

    public static String[] tokenize(String input) {
        return IlrPropertyBundle.tokenize(input, " \t\n\r\f,;", null);
    }

    public static String[] tokenize(String input, String separators, String prefix) {
        Vector<String> v = new Vector<String>();
        StringTokenizer t = new StringTokenizer(input, separators);
        while (t.hasMoreTokens()) {
            v.addElement(t.nextToken());
        }
        String[] cmd = new String[v.size()];
        for (int i = 0; i < cmd.length; ++i) {
            cmd[i] = prefix == null ? (String)v.elementAt(i) : prefix + (String)v.elementAt(i);
        }
        return cmd;
    }

    public class Bundle
    extends ResourceBundle {
        public Enumeration getKeys() {
            return IlrPropertyBundle.this.properties.keys();
        }

        @Override
        public Object handleGetObject(String key) throws MissingResourceException {
            if (IlrPropertyBundle.this.properties.containsKey(key)) {
                return IlrPropertyBundle.this.properties.get(key);
            }
            throw new MissingResourceException("Missing resource: " + key, IlrPropertyBundle.class.getName(), key);
        }
    }
}

