/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util.xml;

import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class IlrXmlDomSaxConverter {
    transient ContentHandler contentHandler = null;
    private static final String XMLNS_STR = "xmlns";
    private static final char SEMICOLUMN_CHAR = ':';

    public void parse(Document document, ContentHandler contentHandler) throws SAXException {
        this.contentHandler = contentHandler;
        this.notifyStartDocument();
        this.convertNamespaceAttributes(document.getAttributes(), true);
        this.convertElement(document.getDocumentElement());
        this.convertNamespaceAttributes(document.getAttributes(), false);
        this.notifyEndDocument();
    }

    protected void convertElement(Element domElement) throws SAXException {
        NamedNodeMap domAttrs = domElement.getAttributes();
        this.convertNamespaceAttributes(domAttrs, true);
        Attributes saxAttrs = this.convertAttributes(domAttrs);
        this.notifyStartElement(domElement.getNamespaceURI(), domElement.getLocalName(), domElement.getTagName(), saxAttrs);
        this.convertElementChilds(domElement.getChildNodes());
        this.notifyEndElement(domElement.getNamespaceURI(), domElement.getLocalName(), domElement.getTagName());
        this.convertNamespaceAttributes(domAttrs, false);
    }

    protected void convertElementChilds(NodeList domChilds) throws SAXException {
        if (domChilds != null) {
            block6: for (int i = 0; i < domChilds.getLength(); ++i) {
                Node node = domChilds.item(i);
                switch (node.getNodeType()) {
                    case 4: {
                        this.notifyCharacters(node.getNodeValue());
                        continue block6;
                    }
                    case 1: {
                        this.convertElement((Element)node);
                        continue block6;
                    }
                    case 7: {
                        this.notifyProcessingInstruction(node.getNodeName(), node.getNodeValue());
                        continue block6;
                    }
                    case 3: {
                        this.notifyCharacters(node.getNodeValue());
                        continue block6;
                    }
                }
            }
        }
    }

    protected void convertNamespaceAttributes(NamedNodeMap domAttrs, boolean startFlag) throws SAXException {
        if (domAttrs != null) {
            for (int i = 0; i < domAttrs.getLength(); ++i) {
                Attr attr = (Attr)domAttrs.item(i);
                if (!this.isXmlnsAttribute(attr)) continue;
                if (startFlag) {
                    this.notifyStartPrefixMapping(attr.getLocalName(), attr.getNodeValue());
                    continue;
                }
                this.notifyEndPrefixMapping(attr.getLocalName());
            }
        }
    }

    protected Attributes convertAttributes(NamedNodeMap domAttrs) throws SAXException {
        AttributesImpl saxAttrs = new AttributesImpl();
        if (domAttrs != null) {
            for (int i = 0; i < domAttrs.getLength(); ++i) {
                Attr attr = (Attr)domAttrs.item(i);
                if (this.isXmlnsAttribute(attr)) continue;
                saxAttrs.addAttribute(attr.getNamespaceURI(), attr.getLocalName(), attr.getName(), null, attr.getValue());
            }
        }
        return saxAttrs;
    }

    private final String getQualifiedName(Node node) {
        return node.getPrefix() == null ? node.getLocalName() : node.getPrefix() + ':' + node.getLocalName();
    }

    private final boolean isXmlnsAttribute(Attr attr) {
        return XMLNS_STR.equals(attr.getLocalName()) || XMLNS_STR.equals(attr.getPrefix());
    }

    private final void notifyStartDocument() throws SAXException {
        this.contentHandler.startDocument();
    }

    private final void notifyEndDocument() throws SAXException {
        this.contentHandler.endDocument();
    }

    private final void notifyStartElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.contentHandler.startElement(namespaceURI, localName, qName, atts);
    }

    private final void notifyEndElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.contentHandler.endElement(namespaceURI, localName, qName);
    }

    private final void notifyCharacters(String str) throws SAXException {
        this.contentHandler.characters(str.toCharArray(), 0, str.length());
    }

    private final void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    private final void notifyProcessingInstruction(String target, String data) throws SAXException {
        this.contentHandler.processingInstruction(target, data);
    }

    private final void setDocumentLocator(Locator locator) throws SAXException {
    }

    private final void skippedEntity(String name) throws SAXException {
    }

    private final void notifyStartPrefixMapping(String prefix, String uri) throws SAXException {
        this.contentHandler.startPrefixMapping(prefix, uri);
    }

    private final void notifyEndPrefixMapping(String prefix) throws SAXException {
        this.contentHandler.endPrefixMapping(prefix);
    }
}

