/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util.xml;

import ilog.rules.util.prefs.IlrMessages;
import ilog.rules.util.xml.IlrXmlConstants;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class IlrXmlSAXException
extends SAXException
implements IlrXmlConstants {
    private String prefixedMessage;
    private Object[] args;

    public IlrXmlSAXException(String prefix, String msgId, Locator locator, Exception exception) {
        super(msgId, exception);
        this.prefixedMessage = prefix + "." + msgId;
        this.args = IlrXmlSAXException.buildArguments(locator);
    }

    public IlrXmlSAXException(String prefix, String msgId, Object arg1, Locator locator, Exception exception) {
        super(msgId, exception);
        this.prefixedMessage = prefix + "." + msgId;
        this.args = IlrXmlSAXException.buildArguments(arg1, locator);
    }

    public IlrXmlSAXException(String prefix, String msgId, Object arg1, Object arg2, Locator locator, Exception exception) {
        super(msgId, exception);
        this.prefixedMessage = prefix + "." + msgId;
        this.args = IlrXmlSAXException.buildArguments(arg1, arg2, locator);
    }

    public IlrXmlSAXException(String prefix, String msgId, Object[] args, Locator locator, Exception exception) {
        super(msgId, exception);
        this.prefixedMessage = prefix + "." + msgId;
        this.args = IlrXmlSAXException.buildArguments(args, locator);
    }

    @Override
    public String toString() {
        return this.getMessage();
    }

    public String getMessageId() {
        return super.getMessage();
    }

    public Object[] getArguments() {
        return this.args;
    }

    @Override
    public String getMessage() {
        return IlrMessages.getMessage(this.prefixedMessage, this.args);
    }

    private static Object[] buildArguments(Object[] args, Locator locator) {
        if (locator == null) {
            return args;
        }
        Object[] res = new Object[3 + args.length];
        System.arraycopy(args, 0, res, 0, args.length);
        String publicId = locator.getPublicId();
        publicId = publicId == null ? "unknown" : publicId;
        res[args.length] = publicId;
        res[args.length + 1] = Integer.toString(locator.getLineNumber());
        res[args.length + 2] = Integer.toString(locator.getColumnNumber());
        return res;
    }

    private static Object[] buildArguments(Locator locator) {
        Object[] args = new String[]{};
        return IlrXmlSAXException.buildArguments(args, locator);
    }

    private static Object[] buildArguments(Object arg, Locator locator) {
        Object[] args = new Object[]{arg};
        return IlrXmlSAXException.buildArguments(args, locator);
    }

    private static Object[] buildArguments(Object arg1, Object arg2, Locator locator) {
        Object[] args = new Object[]{arg1, arg2};
        return IlrXmlSAXException.buildArguments(args, locator);
    }
}

