/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util.xml;

import ilog.rules.util.prefs.IlrPreferences;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public class IlrXmlWriter
extends PrintWriter {
    private int indent = 0;
    private int disableIndentCount = 0;

    public IlrXmlWriter(Writer writer) {
        super(writer);
    }

    public IlrXmlWriter(OutputStream stream) {
        super(stream);
    }

    public void printIndent() {
        this.printIndent(this.indent);
    }

    public void printLine(String s) {
        this.printIndent();
        this.println(s);
    }

    public void printStartTag(String tag) {
        this.printIndent();
        StringBuffer sb = new StringBuffer(20);
        sb.append("<").append(tag).append(">");
        this.println(sb.toString());
    }

    public void printStartTag(String tag, boolean withNewline) {
        this.printIndent();
        StringBuffer sb = new StringBuffer(20);
        sb.append('<').append(tag).append('>');
        String s = sb.toString();
        if (withNewline) {
            this.println(s);
        } else {
            this.print(s);
        }
    }

    public void printEndTag(String tag) {
        this.printIndent();
        StringBuffer sb = new StringBuffer(20);
        sb.append('<').append('/').append(tag).append('>');
        this.println(sb.toString());
    }

    public void printEndTag(String tag, boolean withIndent) {
        if (withIndent) {
            this.printIndent();
        }
        StringBuffer sb = new StringBuffer(20);
        sb.append('<').append('/').append(tag).append('>');
        this.println(sb.toString());
    }

    public void printInTag(String tag, String s) {
        StringBuffer sb = new StringBuffer(20);
        if (s != null && s.length() > 0) {
            this.printIndent();
            sb.append('<').append(tag).append('>');
            this.print(sb.toString());
            this.print(this.CDATA(s));
            sb.setLength(0);
            sb.append('<').append('/').append(tag).append('>');
            this.println(sb.toString());
        }
    }

    public void printEmptyTag(String tag, boolean withIndent) {
        if (withIndent) {
            this.printIndent();
        }
        StringBuffer sb = new StringBuffer(20);
        sb.append('<').append(tag).append('/').append('>');
        this.print(sb.toString());
    }

    public void printStartEmptyTag(String tag) {
        this.printIndent();
        StringBuffer sb = new StringBuffer(20);
        sb.append('<').append(tag);
        this.print(sb.toString());
    }

    public void printAttribute(String aname, String value) {
        StringBuffer sb = new StringBuffer(50);
        sb.append(' ').append(aname);
        sb.append('=').append('\"');
        sb.append(IlrXmlWriter.escape(value));
        sb.append('\"').append(' ');
        this.print(sb.toString());
    }

    public void printEndEmptyTag() {
        this.println("/>");
    }

    public void printProcessingInstruction(String target, String data) {
        StringBuffer sb = new StringBuffer(50);
        sb.append("<?").append(target);
        sb.append(' ').append(data).append(" ?>");
        this.print(sb.toString());
    }

    public String CDATA(String s) {
        if (s != null) {
            return IlrXmlWriter.escape(s);
        }
        return null;
    }

    public void printCDATA(String text) {
        this.print(this.CDATA(text));
    }

    public void printlnCDATA(String text) {
        this.printIndent();
        this.println(this.CDATA(text));
    }

    public static String escape(String s) {
        if (s == null) {
            return null;
        }
        int length = s.length();
        StringBuffer result = new StringBuffer(length * 4);
        boolean noRCescape = IlrPreferences.getBoolean("repository.facility.noRCescape", true);
        block10: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    result.append("&lt;");
                    continue block10;
                }
                case '>': {
                    result.append("&gt;");
                    continue block10;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block10;
                }
                case '\'': {
                    result.append("&apos;");
                    continue block10;
                }
                case '&': {
                    result.append("&amp;");
                    continue block10;
                }
                case '\n': {
                    if (noRCescape) {
                        result.append('\n');
                        continue block10;
                    }
                }
                case '\r': {
                    if (noRCescape) {
                        result.append('\r');
                        continue block10;
                    }
                }
                case '\b': 
                case '\t': 
                case '\f': 
                case '/': 
                case ']': {
                    result.append("&#").append((int)c).append(';');
                    continue block10;
                }
                default: {
                    if (c < '\u0014' || c > '\u007f') {
                        result.append("&#").append((int)c).append(';');
                        continue block10;
                    }
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public int getIndent() {
        return this.indent;
    }

    public void incIndent() {
        ++this.indent;
    }

    public void decIndent() {
        --this.indent;
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }

    public void beginDisableIndent() {
        ++this.disableIndentCount;
    }

    public void endDisableIndent() {
        --this.disableIndentCount;
    }

    protected void setDisableIndentCount(int count) {
        this.disableIndentCount = count;
    }

    public int disableIndentCount() {
        return this.disableIndentCount;
    }

    protected void printIndent(int indent) {
        if (this.disableIndentCount == 0) {
            this.print(this.makeIndent(indent));
        }
    }

    private String makeIndent(int indent) {
        StringBuffer s = new StringBuffer(indent);
        for (int i = 0; i < indent; ++i) {
            s.append(' ');
        }
        return s.toString();
    }
}

