--
--
-- Licensed Materials - Property of IBM
-- 5724X98 5724Y15 5655V82 5724X99 5724Y16 5655V89 5725B69 5655W88 5725C52 5655W90 5655Y31
-- Copyright IBM Corp. 1987, 2015 All Rights Reserved
-- US Government Users Restricted Rights - Use, duplication or
-- disclosure restricted by GSA ADP Schedule Contract with
-- IBM Corp.
--
--
DROP TRIGGER RULESETS_TRIGGER;
DROP TRIGGER RULEAPPS_TRIGGER;
DROP INDEX RULESETS.RULESETS_IDX;
DROP VIEW RS_ENABLED_VIEW;
DROP TABLE RULEAPP_PROPERTIES;
DROP TABLE RULESET_PROPERTIES;
DROP TABLE RULESET_RESOURCES;
DROP TABLE RULESETS;
DROP TABLE RULEAPPS;

CREATE TABLE RULEAPPS (
  ID NUMERIC(10, 0) IDENTITY NOT NULL,
  NAME VARCHAR(255) NOT NULL,
  MAJOR_VERSION INT NOT NULL,
  MINOR_VERSION INT NOT NULL,
  CREATION_DATE NUMERIC(15, 0) NOT NULL,
  DISPLAY_NAME VARCHAR(255) NULL,
  DESCRIPTION VARCHAR(255) NULL,
  CONSTRAINT RA_PK PRIMARY KEY (ID),
  CONSTRAINT RA_UNIQUE UNIQUE (NAME, MAJOR_VERSION, MINOR_VERSION)
);

CREATE TABLE RULESETS (
  ID NUMERIC(10, 0) IDENTITY NOT NULL,
  NAME VARCHAR(255) NOT NULL,
  MAJOR_VERSION INT NOT NULL,
  MINOR_VERSION INT NOT NULL,
  CREATION_DATE NUMERIC(15, 0) NOT NULL,
  DISPLAY_NAME VARCHAR(255) NULL,
  DESCRIPTION VARCHAR(255) NULL,
  RULEAPP_ID  NUMERIC(10, 0) NOT NULL,
  CONSTRAINT RS_PK PRIMARY KEY (ID),
  CONSTRAINT RS_UNIQUE UNIQUE (RULEAPP_ID, NAME, MAJOR_VERSION, MINOR_VERSION)
);

CREATE TABLE RULEAPP_PROPERTIES (
  ID NUMERIC(10, 0) IDENTITY NOT NULL,
  RULEAPP_ID  NUMERIC(10, 0) NOT NULL,
  NAME VARCHAR(255) NOT NULL,
  VALUE TEXT NOT NULL,
  CONSTRAINT RA_PROPS_PK PRIMARY KEY (ID),
  CONSTRAINT RA_PROPS_UN UNIQUE (RULEAPP_ID, NAME)
);

CREATE TABLE RULESET_PROPERTIES (
  ID NUMERIC(10, 0) IDENTITY NOT NULL,
  RULESET_ID  NUMERIC(10, 0) NOT NULL,
  NAME VARCHAR(255) NOT NULL,
  VALUE TEXT NOT NULL,
  CONSTRAINT RS_PROPS_PK PRIMARY KEY (ID),
  CONSTRAINT RS_PROPS_UN UNIQUE (RULESET_ID, NAME)
);

CREATE TABLE RULESET_RESOURCES (
  ID NUMERIC(10, 0) IDENTITY NOT NULL,
  RULESET_ID  NUMERIC(10, 0) NOT NULL,
  ARCHIVE IMAGE NOT NULL,
  CONSTRAINT RS_RES_PK PRIMARY KEY (ID)
);

CREATE INDEX RULESETS_IDX ON RULESETS (NAME, MAJOR_VERSION, MINOR_VERSION);

CREATE VIEW RS_ENABLED_VIEW AS
SELECT RA.ID AS RA_ID, RA.NAME AS RA_NAME, RA.MAJOR_VERSION AS RA_MAJVERS, RA.MINOR_VERSION AS RA_MINVERS,
       RS.ID AS RS_ID, RS.NAME AS RS_NAME, RS.MAJOR_VERSION AS RS_MAJVERS, RS.MINOR_VERSION AS RS_MINVERS
FROM RULEAPPS RA, RULESETS RS, RULESET_PROPERTIES P
WHERE RS.RULEAPP_ID = RA.ID AND RS.ID = P.RULESET_ID
AND P.NAME = 'ruleset.status' AND CONVERT(VARCHAR(8), P.VALUE) = 'enabled';

CREATE TRIGGER RULESETS_TRIGGER
ON RULESETS 
FOR DELETE AS 
BEGIN 
    DELETE RULESET_PROPERTIES FROM RULESET_PROPERTIES, deleted 
    WHERE deleted.ID = RULESET_PROPERTIES.RULESET_ID
    DELETE RULESET_RESOURCES FROM RULESET_RESOURCES, deleted 
    WHERE deleted.ID = RULESET_RESOURCES.RULESET_ID
END;

CREATE TRIGGER RULEAPPS_TRIGGER
ON RULEAPPS 
FOR DELETE AS 
BEGIN 
    DELETE RULEAPP_PROPERTIES FROM RULEAPP_PROPERTIES, deleted 
    WHERE deleted.ID = RULEAPP_PROPERTIES.RULEAPP_ID
    DELETE RULESETS FROM RULESETS, deleted 
    WHERE deleted.ID = RULESETS.RULEAPP_ID
END;
