/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.image.client;

import com.alibaba.fastjson.JSONObject;
import com.sinosoft.image.client.dto.ImgBatchModifyRequestDTO;
import com.sinosoft.image.client.dto.ImgBatchModifyResponseDTO;
import com.sinosoft.image.client.dto.ImgBatchUploadMetaDTO;
import com.sinosoft.image.client.dto.ImgBatchUploadRequestDTO;
import com.sinosoft.image.client.dto.ImgBatchUploadResponseDTO;
import com.sinosoft.image.client.dto.ImgBusiDTO;
import com.sinosoft.image.client.internal.HttpClient;
import com.sinosoft.image.client.utils.ImgUtils;
import com.sinosoft.image.exception.ImgClientException;
import java.io.File;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImgManagerClient {
    private String imgServiceURL;

    public ImgManagerClient(String imgServiceURL) {
        this.imgServiceURL = imgServiceURL;
    }

    public ImgBatchUploadResponseDTO batchUpload(ImgBatchUploadRequestDTO batchUploadDto, List<File> uploadFiles) {
        ImgUtils.assertParameterNotNull(batchUploadDto, "batchUploadVo");
        ImgUtils.assertParameterNotNull(batchUploadDto.getBusiDto(), "ImgBatchUploadRequestDTO.BusiDto");
        ImgBusiDTO busiDto = batchUploadDto.getBusiDto();
        List<ImgBatchUploadMetaDTO> uploadMetas = batchUploadDto.getUploadMetas();
        ImgUtils.assertParameterNotNull(uploadMetas, "ImgBatchUploadRequestDTO.UploadMetas");
        ImgUtils.assertStringNotNull(busiDto.getAppCode(), "ImgBusiDTO.AppCode");
        ImgUtils.assertStringNotNull(busiDto.getBusinessNo(), "ImgBusiDTO.BusinessNo");
        ImgUtils.assertStringNotNull(busiDto.getBusiComCode(), "ImgBusiDTO.busiComCode");
        String apiUrl = String.valueOf(this.imgServiceURL) + "/api/RESTful.api/batchUploadFile";
        HttpClient httpClient = new HttpClient();
        String jsonObj = JSONObject.toJSONString((Object)batchUploadDto);
        String responeStr = httpClient.postJsonData(apiUrl, jsonObj, uploadFiles);
        ImgBatchUploadResponseDTO responseDto = null;
        try {
            responseDto = (ImgBatchUploadResponseDTO)JSONObject.parseObject((String)responeStr, ImgBatchUploadResponseDTO.class);
        }
        catch (Exception e) {
            throw new ImgClientException(String.valueOf(e.getMessage()) + ",json=" + responeStr, (Throwable)e);
        }
        return responseDto;
    }

    public ImgBatchModifyResponseDTO batchUpload(ImgBatchModifyRequestDTO batchUModifyploadDto) {
        ImgUtils.assertParameterNotNull(batchUModifyploadDto, "batchUploadVo");
        ImgUtils.assertParameterNotNull(batchUModifyploadDto.getBusiDto(), "ImgBatchModifyRequestDTO.BusiDto");
        ImgBusiDTO busiDto = batchUModifyploadDto.getBusiDto();
        ImgUtils.assertStringNotNull(busiDto.getAppCode(), "ImgBusiDTO.AppCode");
        ImgUtils.assertStringNotNull(busiDto.getBusinessNo(), "ImgBusiDTO.BusinessNo");
        ImgUtils.assertStringNotNull(busiDto.getBusiComCode(), "ImgBusiDTO.busiComCode");
        ImgBatchModifyResponseDTO responseDto = null;
        String apiUrl = String.valueOf(this.imgServiceURL) + "/api/RESTful.api/batchModifyData";
        HttpClient httpClient = new HttpClient();
        String jsonObj = JSONObject.toJSONString((Object)batchUModifyploadDto);
        String responeStr = httpClient.postJsonData(apiUrl, jsonObj);
        try {
            responseDto = (ImgBatchModifyResponseDTO)JSONObject.parseObject((String)responeStr, ImgBatchModifyResponseDTO.class);
        }
        catch (Exception e) {
            throw new ImgClientException(String.valueOf(e.getMessage()) + ",json=" + responeStr, (Throwable)e);
        }
        return responseDto;
    }
}

