/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.image.client.common;

import com.sinosoft.image.client.utils.LogUtils;
import java.io.InputStream;
import java.util.Properties;

public class VersionInfo {
    private static final String VERSION_INFO_FILE = "version.properties";
    private static final String USER_AGENT_PREFIX = "h5img-sdk-java";
    private static String version = null;
    private static String defaultUserAgent = null;

    public static String getVersion() {
        if (version == null) {
            VersionInfo.initializeVersion();
        }
        return version;
    }

    public static String getDefaultUserAgent() {
        if (defaultUserAgent == null) {
            defaultUserAgent = "h5img-sdk-java/" + VersionInfo.getVersion() + "(" + System.getProperty("os.name") + "/" + System.getProperty("os.version") + "/" + System.getProperty("os.arch") + ";" + System.getProperty("java.version") + ")";
        }
        return defaultUserAgent;
    }

    private static void initializeVersion() {
        InputStream inputStream = VersionInfo.class.getClassLoader().getResourceAsStream(VERSION_INFO_FILE);
        Properties versionInfoProperties = new Properties();
        try {
            if (inputStream == null) {
                throw new IllegalArgumentException("version.properties not found on classpath");
            }
            versionInfoProperties.load(inputStream);
            version = versionInfoProperties.getProperty("version");
        }
        catch (Exception e) {
            LogUtils.logException("Unable to load version information for the running SDK: ", e);
            version = "unknown-version";
        }
    }
}

