/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.image.client.internal;

import com.sinosoft.image.client.common.HttpMethod;
import com.sinosoft.image.client.internal.RequestMessage;
import com.sinosoft.image.client.internal.ResponseMessage;
import com.sinosoft.image.client.internal.ResponseMessageBuilder;
import com.sinosoft.image.client.utils.HttpUtil;
import com.sinosoft.image.exception.ImgClientException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClient {
    private static final String CharSet = "UTF-8";

    public ResponseMessage send(RequestMessage requestMsg) {
        return this.send(requestMsg, 0);
    }

    public ResponseMessage send(RequestMessage requestMsg, int responseType) {
        URLConnection conn = null;
        HttpURLConnection httpConn = null;
        String requestUrl = requestMsg.getRequestUrl();
        ResponseMessage responseMsg = null;
        try {
            try {
                OutputStream out;
                URL url = new URL(requestUrl);
                conn = url.openConnection();
                conn.setUseCaches(false);
                conn.setDoOutput(true);
                conn.setDoInput(true);
                httpConn = (HttpURLConnection)conn;
                httpConn.setRequestProperty("Cache-Control", "no-cache");
                Map<String, String> headers = requestMsg.getHeaders();
                for (String headerKey : headers.keySet()) {
                    httpConn.setRequestProperty(headerKey, headers.get(headerKey));
                }
                httpConn.setRequestMethod(requestMsg.getMethod().name());
                if (requestMsg.getContentObjs() != null && requestMsg.getContentObjs().length > 0) {
                    ObjectOutputStream outStream = new ObjectOutputStream(httpConn.getOutputStream());
                    Object[] objectArray = requestMsg.getContentObjs();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        outStream.writeObject(obj);
                        ++n2;
                    }
                    outStream.flush();
                    outStream.close();
                } else if (requestMsg.getContentByte() != null && requestMsg.getContentByte().length > 0) {
                    out = httpConn.getOutputStream();
                    out.write(requestMsg.getContentByte());
                    out.flush();
                    out.close();
                } else if (requestMsg.getContentJson() != null && requestMsg.getContentJson().length() > 0) {
                    httpConn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                    httpConn.connect();
                    out = httpConn.getOutputStream();
                    out.write(requestMsg.getContentJson().getBytes());
                    out.flush();
                    out.close();
                } else {
                    String paramContent = HttpUtil.paramToQueryString(requestMsg.getParameters(), headers.get("Content-Encoding"));
                    DataOutputStream out2 = new DataOutputStream(httpConn.getOutputStream());
                    out2.writeBytes(paramContent);
                    out2.flush();
                    out2.close();
                }
                if (responseType == 0) {
                    responseMsg = new ResponseMessageBuilder(httpConn).parseHeaders().parseStatus().parseResultObject().build();
                } else if (responseType == 1) {
                    responseMsg = new ResponseMessageBuilder(httpConn).parseHeaders().parseStatus().parseResultByte().build();
                } else if (responseType == 2) {
                    responseMsg = new ResponseMessageBuilder(httpConn).parseHeaders().parseStatus().parseResultJson().build();
                }
            }
            catch (IOException e) {
                throw new ImgClientException(requestUrl, (Throwable)e);
            }
        }
        finally {
            if (conn != null) {
                httpConn.disconnect();
            }
        }
        return responseMsg;
    }

    public byte[] getFileContent(String httpURL) throws IOException {
        byte[] data;
        URL url = null;
        HttpURLConnection conn = null;
        FilterInputStream input = null;
        try {
            url = new URL(httpURL);
            conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(10000);
            conn.setUseCaches(false);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            input = new DataInputStream(conn.getInputStream());
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            data = null;
            byte[] b = new byte[1024];
            int read = 0;
            while ((read = ((DataInputStream)input).read(b)) != -1) {
                byteOut.write(b, 0, read);
            }
            data = byteOut.toByteArray();
        }
        finally {
            if (input != null) {
                input.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return data;
    }

    public static String loadUrl(String url) {
        String resultContent = null;
        CloseableHttpClient httpclient = null;
        CloseableHttpResponse response = null;
        try {
            try {
                httpclient = HttpClients.createDefault();
                HttpGet httpget = new HttpGet(url);
                response = httpclient.execute((HttpUriRequest)httpget);
                HttpEntity entity = response.getEntity();
                resultContent = EntityUtils.toString((HttpEntity)entity);
            }
            catch (IOException e) {
                resultContent = e.getMessage();
                e.printStackTrace();
                try {
                    if (response != null) {
                        response.close();
                    }
                    if (httpclient != null) {
                        httpclient.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                if (httpclient != null) {
                    httpclient.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultContent;
    }

    public String postXMLData(String requestUrl, String xmlData) {
        StringBuffer resultContent;
        block8: {
            HttpURLConnection connection = null;
            resultContent = new StringBuffer();
            try {
                try {
                    URL url = new URL(requestUrl);
                    connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod(HttpMethod.POST.name());
                    connection.setConnectTimeout(3000);
                    connection.setDoOutput(true);
                    connection.setDoInput(true);
                    connection.setUseCaches(false);
                    connection.setRequestProperty("Content-Type", "text/xml;charset=utf-8");
                    connection.setRequestProperty("Connetion", "Keep-Alive");
                    connection.connect();
                    OutputStream out = connection.getOutputStream();
                    out.write(xmlData.getBytes(CharSet));
                    out.flush();
                    out.close();
                    int code = connection.getResponseCode();
                    if (code == 200) {
                        String line;
                        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                        while ((line = reader.readLine()) != null) {
                            resultContent.append(line).append("\n");
                        }
                        reader.close();
                        break block8;
                    }
                    throw new ImgClientException(String.valueOf(requestUrl) + " read error,code= " + code);
                }
                catch (IOException e) {
                    throw new ImgClientException(requestUrl, (Throwable)e);
                }
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
        return resultContent.toString();
    }

    public String postJsonData(String url, String jsonData) {
        String resultContent = null;
        CloseableHttpClient httpclient = null;
        CloseableHttpResponse response = null;
        try {
            try {
                httpclient = HttpClients.createDefault();
                HttpPost httpPost = new HttpPost(url);
                httpPost.addHeader("Content-Type", "application/json; charset=UTF-8");
                StringEntity postEntity = new StringEntity(jsonData, CharSet);
                postEntity.setContentType("text/json");
                httpPost.setEntity((HttpEntity)postEntity);
                response = httpclient.execute((HttpUriRequest)httpPost);
                HttpEntity entity = response.getEntity();
                resultContent = EntityUtils.toString((HttpEntity)entity, (String)CharSet);
            }
            catch (IOException e) {
                resultContent = e.getMessage();
                e.printStackTrace();
                try {
                    if (response != null) {
                        response.close();
                    }
                    if (httpclient != null) {
                        httpclient.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                if (httpclient != null) {
                    httpclient.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultContent;
    }

    public String postJsonData(String apiUrl, String jsonData, List<File> fileList) {
        String resultContent = null;
        CloseableHttpClient client = HttpClients.createDefault();
        ContentType strContent = ContentType.create((String)"text/plain", (Charset)Charset.forName(CharSet));
        HttpPost httpPost = new HttpPost(apiUrl);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.RFC6532);
        if (fileList != null && !fileList.isEmpty()) {
            int i = 0;
            while (i < fileList.size()) {
                builder.addBinaryBody("file" + i, fileList.get(i));
                ++i;
            }
        }
        builder.addTextBody("jsonData", jsonData, strContent);
        HttpEntity entity = builder.build();
        httpPost.setEntity(entity);
        try {
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity != null) {
                resultContent = EntityUtils.toString((HttpEntity)responseEntity, (String)CharSet);
            }
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resultContent;
    }
}

