/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.image.client.internal;

import com.sinosoft.image.client.common.HttpMethod;
import com.sinosoft.image.client.common.VersionInfo;
import com.sinosoft.image.client.internal.RequestMessage;
import com.sinosoft.image.client.utils.DateUtil;
import com.sinosoft.image.exception.ImgClientException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class RequestMessageBuilder {
    private String requestUrl;
    private HttpMethod method = HttpMethod.GET;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> parameters = new LinkedHashMap<String, String>();
    private Object[] contentObjs;
    private String contentJson;
    private byte[] contentByte;
    private long inputSize = 0L;
    private boolean useChunkEncoding = false;

    public RequestMessageBuilder(String imgServiceURL, String servletPath) {
        this.headers.put("Content-Type", "application/x-www-form-urlencoded");
        this.requestUrl = this.chenkUrlPath(imgServiceURL, servletPath);
    }

    public RequestMessageBuilder setClientNetType(String clientNetType) {
        this.headers.put("Client-Net-Type", clientNetType);
        return this;
    }

    public RequestMessageBuilder setMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    public RequestMessageBuilder setContentObj(Object ... contentObjs) {
        this.contentObjs = contentObjs;
        this.headers.put("Content-Type", "application/x-java-serialized-object");
        return this;
    }

    public RequestMessageBuilder setContentJson(String json) {
        this.contentJson = json;
        return this;
    }

    public RequestMessageBuilder setContentByte(byte[] contentByte) {
        this.contentByte = contentByte;
        this.inputSize = contentByte.length;
        this.headers.put("Content-Type", "application/octet-stream");
        return this;
    }

    public RequestMessageBuilder addParamer(String key, String value) {
        this.parameters.put(key, value);
        return this;
    }

    public RequestMessageBuilder addHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public RequestMessage build() {
        Date requestTime = new Date();
        HashMap<String, String> sentHeaders = new HashMap<String, String>(this.headers);
        sentHeaders.put("Date", DateUtil.formatRfc822Date(requestTime));
        sentHeaders.put("Client-UserAgent", VersionInfo.getDefaultUserAgent());
        RequestMessage request = new RequestMessage(this.requestUrl);
        request.setRequestTime(requestTime);
        request.setHeaders(sentHeaders);
        request.setParameters(this.parameters);
        request.setMethod(this.method);
        request.setContentObjs(this.contentObjs);
        request.setContentByte(this.contentByte);
        request.setContentJson(this.contentJson);
        request.setContentLength(this.inputSize);
        request.setUseChunkEncoding(this.inputSize < 1L ? true : this.useChunkEncoding);
        return request;
    }

    private String chenkUrlPath(String imgServerUrl, String servletPath) {
        if (imgServerUrl == null || imgServerUrl.trim().equals("")) {
            throw new ImgClientException("The parameter {imgServerUrl} is null.");
        }
        if (!(imgServerUrl = imgServerUrl.trim()).startsWith("http")) {
            throw new ImgClientException("The parameter {imgServerUrl} must start with http or https.");
        }
        if (imgServerUrl.endsWith("/")) {
            imgServerUrl.substring(0, imgServerUrl.length() - 1);
        }
        String reqUrl = String.valueOf(imgServerUrl) + servletPath;
        return reqUrl;
    }
}

