package com.sinosoftgz.starter.log.aoplog.config;

import com.alibaba.fastjson.JSON;
import com.sinosoftgz.starter.log.aoplog.properties.AopLogProperties;
import com.sinosoftgz.starter.utils.lang.Lang;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.AfterReturningAdvice;
import org.springframework.aop.MethodBeforeAdvice;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@ConditionalOnProperty(name = "aoplog.enabled", havingValue = "true", matchIfMissing = false)
@Component
@Configuration
public class MethodAspectConfig implements MethodBeforeAdvice, AfterReturningAdvice, MethodInterceptor {


    @Autowired
    AopLogProperties aopLogProperties;
    private Logger logger = LoggerFactory.getLogger(MethodAspectConfig.class);


    @Override
    public void afterReturning(Object returnValue, java.lang.reflect.Method method, Object[] args, Object target) throws Throwable {

    }

    @Override
    public void before(java.lang.reflect.Method method, Object[] args, Object target) throws Throwable {

    }


    @Bean("defaultPointcutAdvisor")
    public DefaultPointcutAdvisor createDefaultPointcutAdvisor() {

        DefaultPointcutAdvisor defaultPointcutAdvisor = new DefaultPointcutAdvisor();
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        MethodAspectConfig advices = new MethodAspectConfig();
        pointcut.setExpression(aopLogProperties.getBasePackage());

        defaultPointcutAdvisor.setPointcut(pointcut);
        defaultPointcutAdvisor.setAdvice(advices);
        return defaultPointcutAdvisor;
    }

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object proceed;
        String className = "";
        String methodName = "";
        long time = 0L;
        List<Object> argsList = new ArrayList<>();
        try {
            time = System.currentTimeMillis();
            className = invocation.getThis().getClass().getName();//获取类名
            methodName = invocation.getMethod().getName(); // 获得方法名
            // 获得方法参数
            Object[] args = invocation.getArguments();
            argsList = Arrays.asList(args);
        } catch (Exception e) {
            logger.error("[AOP-LOG]监控类名称.方法名称为:{}.{},调用异常", className, methodName, e);
        } finally {
            /**
             * 方法返回值
             */
            proceed = invocation.proceed();
            logger.info("[AOP-LOG]监控类名称.方法名称(请求参数)为:{}.{}({}),方法返回值是{},调用耗时:{}ms", className, methodName, JSON.toJSONString(argsList), JSON.toJSONString(proceed), System.currentTimeMillis() - time);
        }

        return proceed;
    }
}
