package com.sinosoftgz.starter.log.logging;

import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.context.logging.LoggingApplicationListener;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.StringUtils;

import java.util.Properties;

/**
 * @author: Roney
 * @date: 2021-11-08 16:09
 * @description: 增加日志appName
 */
public class ComponentLoggingApplicationListener extends LoggingApplicationListener {

    /**
     * 增加app name start
     */
    /**
     * 增加app name
     */
    public static final String APP_NAME_PROPERTY = "logging.appName";

    public static final String APP_NAME = "APP_NAME";

    /**
     * 增加app name end
     */
    @Override
    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationEnvironmentPreparedEvent) {
            ConfigurableEnvironment environment = ((ApplicationEnvironmentPreparedEvent) event).getEnvironment();
            setAppName(environment);
        }
        super.onApplicationEvent(event);

    }


    /**
     * 设置app name
     *
     * @param environment
     */
    private void setAppName(ConfigurableEnvironment environment) {
        String appName = StringUtils.trimWhitespace(environment.getProperty(APP_NAME_PROPERTY));
        if (!StringUtils.hasLength(appName)) {
            appName = "spring-boot-app";
        }
        Properties properties = System.getProperties();
        properties.put(APP_NAME, appName);
    }
}
