/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.utils.convert;

import com.sinosoftgz.starter.utils.convert.Converter;
import com.sinosoftgz.starter.utils.convert.converters.array.BlobToByteArrayConverter;
import com.sinosoftgz.starter.utils.convert.converters.array.CollectionToArrayConverter;
import com.sinosoftgz.starter.utils.convert.converters.date.ObjectToDateConverter;
import com.sinosoftgz.starter.utils.convert.converters.date.ObjectToSqlDateConverter;
import com.sinosoftgz.starter.utils.convert.converters.date.ObjectToTimestampConverter;
import com.sinosoftgz.starter.utils.convert.converters.primitive.ObjectToBigDecimalConverter;
import com.sinosoftgz.starter.utils.convert.converters.primitive.ObjectToBigIntegerConverter;
import com.sinosoftgz.starter.utils.convert.converters.primitive.ObjectToBooleanConverter;
import com.sinosoftgz.starter.utils.convert.converters.primitive.ObjectToByteConverter;
import com.sinosoftgz.starter.utils.convert.converters.primitive.ObjectToCharacterConverter;
import com.sinosoftgz.starter.utils.convert.converters.primitive.ObjectToClassConverter;
import com.sinosoftgz.starter.utils.convert.converters.primitive.ObjectToDoubleConverter;
import com.sinosoftgz.starter.utils.convert.converters.primitive.ObjectToFloatConverter;
import com.sinosoftgz.starter.utils.convert.converters.primitive.ObjectToIntegerConverter;
import com.sinosoftgz.starter.utils.convert.converters.primitive.ObjectToLongConverter;
import com.sinosoftgz.starter.utils.convert.converters.primitive.ObjectToShortConverter;
import com.sinosoftgz.starter.utils.convert.converters.string.ClobToStringConverter;
import com.sinosoftgz.starter.utils.convert.converters.string.DateToStringConverter;
import com.sinosoftgz.starter.utils.convert.converters.string.NumberToStringConverter;
import com.sinosoftgz.starter.utils.convert.converters.string.ObjectToStringConverter;
import com.sinosoftgz.starter.utils.lang.Lang;
import com.sinosoftgz.starter.utils.lang.Mirrors;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.collections.map.LRUMap;

public class Converters {
    LRUMap matchConverterMap;
    List<ConverterMeta> converterMetas = Lang.newList(new ConverterMeta[0]);
    public static final Converters BASE = Converters.create();

    public static Converters create(int cache) {
        return new Converters(cache);
    }

    public static Converters create() {
        return Converters.create(1024);
    }

    private Converters(int cache) {
        this.matchConverterMap = new LRUMap(cache);
    }

    public <S, T> Converters add(Class<S> fromType, Class<T> toType, Converter converter) {
        ConverterMeta converterMeta = new ConverterMeta();
        converterMeta.fromType = fromType;
        converterMeta.toType = toType;
        converterMeta.converter = converter;
        this.converterMetas.add(converterMeta);
        return this;
    }

    public <S, T> T convert(S from, Class<T> toType, Object ... args) {
        if (from == null) {
            return null;
        }
        if (toType.isPrimitive()) {
            toType = MethodUtils.getPrimitiveWrapper(toType);
        }
        if (toType.isAssignableFrom(from.getClass())) {
            return (T)from;
        }
        Class<?> fromType = from.getClass();
        int key = Arrays.hashCode(new Object[]{fromType, toType});
        ConverterMeta matchConverterMeta = (ConverterMeta)this.matchConverterMap.get((Object)key);
        if (matchConverterMeta == null) {
            float cost = Float.MAX_VALUE;
            for (ConverterMeta converterMeta : this.converterMetas) {
                float converterCost = Mirrors.getTotalTransformationCost(new Class[]{fromType, converterMeta.toType}, new Class[]{converterMeta.fromType, toType});
                if (converterCost == -1.0f || !(converterCost < cost)) continue;
                cost = converterCost;
                matchConverterMeta = converterMeta;
            }
            if (matchConverterMeta == null) {
                throw new IllegalArgumentException(String.format("Coudn't convert object %s to type %s", from, toType));
            }
            this.matchConverterMap.put((Object)key, (Object)matchConverterMeta);
        }
        Converter converter = matchConverterMeta.converter;
        return (T)converter.convert(from, matchConverterMeta.toType, args);
    }

    public <S, T> T convert(S from, Class<T> toType) {
        return this.convert(from, toType, Lang.EMPTY_ARRAY);
    }

    public void lock() {
        this.converterMetas = Collections.unmodifiableList(this.converterMetas);
    }

    public Converters extend(Converters other) {
        this.converterMetas.addAll(other.converterMetas);
        return this;
    }

    static {
        BASE.add(Object.class, String.class, new ObjectToStringConverter());
        BASE.add(java.util.Date.class, String.class, new DateToStringConverter());
        BASE.add(Number.class, String.class, new NumberToStringConverter());
        BASE.add(Clob.class, String.class, new ClobToStringConverter());
        BASE.add(Object.class, Byte.class, new ObjectToByteConverter());
        BASE.add(Object.class, Short.class, new ObjectToShortConverter());
        BASE.add(Object.class, Integer.class, new ObjectToIntegerConverter());
        BASE.add(Object.class, Long.class, new ObjectToLongConverter());
        BASE.add(Object.class, Float.class, new ObjectToFloatConverter());
        BASE.add(Object.class, Double.class, new ObjectToDoubleConverter());
        BASE.add(Object.class, Boolean.class, new ObjectToBooleanConverter());
        BASE.add(Object.class, Character.class, new ObjectToCharacterConverter());
        BASE.add(Object.class, BigInteger.class, new ObjectToBigIntegerConverter());
        BASE.add(Object.class, BigDecimal.class, new ObjectToBigDecimalConverter());
        BASE.add(Object.class, Class.class, new ObjectToClassConverter());
        BASE.add(Object.class, java.util.Date.class, new ObjectToDateConverter());
        BASE.add(Object.class, Date.class, new ObjectToSqlDateConverter());
        BASE.add(Object.class, Timestamp.class, new ObjectToTimestampConverter());
        BASE.add(Blob.class, byte[].class, new BlobToByteArrayConverter());
        BASE.add(Collection.class, byte[].class, new CollectionToArrayConverter());
        BASE.add(Collection.class, short[].class, new CollectionToArrayConverter());
        BASE.add(Collection.class, int[].class, new CollectionToArrayConverter());
        BASE.add(Collection.class, long[].class, new CollectionToArrayConverter());
        BASE.add(Collection.class, float[].class, new CollectionToArrayConverter());
        BASE.add(Collection.class, double[].class, new CollectionToArrayConverter());
        BASE.add(Collection.class, boolean[].class, new CollectionToArrayConverter());
        BASE.add(Collection.class, char[].class, new CollectionToArrayConverter());
        BASE.add(Collection.class, Byte[].class, new CollectionToArrayConverter());
        BASE.add(Collection.class, Short[].class, new CollectionToArrayConverter());
        BASE.add(Collection.class, Integer[].class, new CollectionToArrayConverter());
        BASE.add(Collection.class, Long[].class, new CollectionToArrayConverter());
        BASE.add(Collection.class, Float[].class, new CollectionToArrayConverter());
        BASE.add(Collection.class, Double[].class, new CollectionToArrayConverter());
        BASE.add(Collection.class, Boolean[].class, new CollectionToArrayConverter());
        BASE.add(Collection.class, Character[].class, new CollectionToArrayConverter());
        BASE.add(Collection.class, BigDecimal[].class, new CollectionToArrayConverter());
        BASE.add(Collection.class, BigInteger[].class, new CollectionToArrayConverter());
        BASE.add(Collection.class, String[].class, new CollectionToArrayConverter());
        BASE.add(Collection.class, java.util.Date[].class, new CollectionToArrayConverter());
        BASE.add(Collection.class, Class[].class, new CollectionToArrayConverter());
        BASE.lock();
    }

    class ConverterMeta {
        Class<?> fromType;
        Class<?> toType;
        Converter converter;

        ConverterMeta() {
        }
    }
}

