/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.utils.filter;

import com.sinosoftgz.starter.utils.filter.InjectionAttackWrapper;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;

public class InjectionAttackFilter
implements Filter {
    private static final String X_FRAME_VALUE = "SAMEORIGIN";
    private static final String X_FRAME_HEADER = "X-FRAME-OPTIONS";
    public static final String FILTER_XSS_PARAM_NAME = "filter_xss";
    public static final String FILTER_SQL_INJECTION_PARAM_NAME = "filter_sql_injection";
    public static final String CLICK_JACKING_HEADER = "click_jacking_header";
    boolean filterXSS = true;
    boolean filterSQL = true;
    boolean clickJacking = true;

    public void setFilterXSS(boolean filterXSS) {
        this.filterXSS = filterXSS;
    }

    public void setFilterSQL(boolean filterSQL) {
        this.filterSQL = filterSQL;
    }

    public void setClickJacking(boolean clickJacking) {
        this.clickJacking = clickJacking;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        InjectionAttackWrapper wrapper = new InjectionAttackWrapper((HttpServletRequest)servletRequest, this.filterXSS, this.filterSQL);
        this.filterClickJack(servletResponse);
        filterChain.doFilter((ServletRequest)wrapper, servletResponse);
    }

    private void filterClickJack(ServletResponse servletResponse) {
        HttpServletResponse httpServletResponse;
        if (this.clickJacking && servletResponse instanceof HttpServletResponse && !(httpServletResponse = (HttpServletResponse)servletResponse).containsHeader(X_FRAME_HEADER)) {
            httpServletResponse.addHeader(X_FRAME_HEADER, X_FRAME_VALUE);
        }
    }

    public void init(FilterConfig config) throws ServletException {
        String filterXSSParam = config.getInitParameter(FILTER_XSS_PARAM_NAME);
        String filterSQLParam = config.getInitParameter(FILTER_SQL_INJECTION_PARAM_NAME);
        String clickJackingParam = config.getInitParameter(CLICK_JACKING_HEADER);
        if (StringUtils.hasText((String)filterXSSParam)) {
            this.filterXSS = new Boolean(filterXSSParam);
        }
        if (StringUtils.hasText((String)filterSQLParam)) {
            this.filterSQL = new Boolean(filterSQLParam);
        }
        if (StringUtils.hasText((String)clickJackingParam)) {
            this.clickJacking = new Boolean(clickJackingParam);
        }
    }
}

