/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.utils.filter.parameter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterTrimRequest
extends HttpServletRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger(ParameterTrimRequest.class);
    private Map<String, String[]> params = new HashMap<String, String[]>();
    private byte[] content;

    public ParameterTrimRequest(HttpServletRequest request) throws Exception {
        super(request);
        this.params.putAll(request.getParameterMap());
        this.modifyParameterValues();
        if (null != request.getContentType() && request.getContentType().contains("application/json")) {
            this.content = IOUtils.toByteArray((InputStream)request.getInputStream());
            String json = new String(this.content);
            JSONObject jsonObject = JSONObject.parseObject((String)json);
            Map map = new HashMap();
            map = (Map)JSON.toJavaObject((JSON)jsonObject, Map.class);
            this.content = map.toString().getBytes();
            try {
                for (Map.Entry entry : map.entrySet()) {
                    if (entry.getValue() instanceof JSONArray || entry.getValue() == null || !(entry.getValue() instanceof String)) continue;
                    map.put(entry.getKey(), entry.getValue().toString().trim());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            log.info("\u8f6c\u5316\u540e\u7684\u53c2\u6570:{}", (Object)map.toString());
            this.content = map.toString().getBytes();
        }
    }

    public void modifyParameterValues() {
        log.info("ParameterTrimFilter:");
        Set<Map.Entry<String, String[]>> entrys = this.params.entrySet();
        for (Map.Entry<String, String[]> entry : entrys) {
            String[] values = entry.getValue();
            for (int i = 0; i < values.length; ++i) {
                values[i] = values[i].trim();
            }
            this.params.put(entry.getKey(), values);
        }
    }

    public Enumeration<String> getParameterNames() {
        return new Vector<String>(this.params.keySet()).elements();
    }

    public String getParameter(String name) {
        String[] values = this.params.get(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public String[] getParameterValues(String name) {
        return this.params.get(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.params;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (!super.getHeader("Content-Type").contains("application/json")) {
            return super.getInputStream();
        }
        final ByteArrayInputStream in = new ByteArrayInputStream(this.content);
        return new ServletInputStream(){

            public int read() throws IOException {
                return in.read();
            }

            public int read(byte[] b, int off, int len) throws IOException {
                return in.read(b, off, len);
            }

            public int read(byte[] b) throws IOException {
                return in.read(b);
            }

            public void setReadListener(ReadListener listener) {
            }

            public boolean isReady() {
                return false;
            }

            public boolean isFinished() {
                return false;
            }

            public long skip(long n) throws IOException {
                return in.skip(n);
            }

            public void close() throws IOException {
                in.close();
            }

            public synchronized void mark(int readlimit) {
                in.mark(readlimit);
            }

            public synchronized void reset() throws IOException {
                in.reset();
            }
        };
    }
}

