/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.utils.lang;

import com.sinosoftgz.starter.utils.convert.Converters;
import com.sinosoftgz.starter.utils.lang.OID;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lang {
    private static final Logger log = LoggerFactory.getLogger(Lang.class);
    private static final String DATE_FORMAT_YYYYMMDDHHMMSS_SSS = "yyyyMMddHHmmssSSS";
    public static final Object EMPTY = new Object();
    public static final Object[] EMPTY_ARRAY = new Object[0];

    private Lang() {
    }

    public static long identityHashCode(Object x) {
        return (long)System.identityHashCode(x) + Integer.MAX_VALUE;
    }

    public static String id() {
        OID oid = new OID();
        return oid.toString();
    }

    public static RuntimeException unchecked(Throwable e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(e);
    }

    public static RuntimeException unchecked(Throwable e, String message, Object ... args) {
        return new RuntimeException(String.format(message, args), e);
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return obj.toString().trim().length() == 0;
        }
        if (obj.getClass().equals(Object.class)) {
            return true;
        }
        if (Lang.isBaseType(obj.getClass())) {
            return false;
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        return Object.class.equals(obj.getClass());
    }

    public static boolean isNotEmpty(Object object) {
        return object != null && !"".equals(object) && !"null".equals(object);
    }

    public static boolean isBaseType(Class<?> type) {
        if (type.isPrimitive()) {
            return true;
        }
        if (CharSequence.class.isAssignableFrom(type)) {
            return true;
        }
        if (Number.class.isAssignableFrom(type)) {
            return true;
        }
        if (Date.class.isAssignableFrom(type)) {
            return true;
        }
        if (Boolean.class.equals(type)) {
            return true;
        }
        if (Character.class.equals(type)) {
            return true;
        }
        if (Class.class.equals(type)) {
            return true;
        }
        if (StringBuilder.class.equals(type)) {
            return true;
        }
        if (StringBuffer.class.equals(type)) {
            return true;
        }
        if (Object.class.equals(type)) {
            return true;
        }
        return Void.class.equals(type);
    }

    public static boolean isNumber(Class<?> type) {
        if (Number.class.isAssignableFrom(type)) {
            return true;
        }
        if (type.equals(Integer.TYPE)) {
            return true;
        }
        if (type.equals(Short.TYPE)) {
            return true;
        }
        if (type.equals(Long.TYPE)) {
            return true;
        }
        if (type.equals(Float.TYPE)) {
            return true;
        }
        if (type.equals(Double.TYPE)) {
            return true;
        }
        return type.equals(Byte.TYPE);
    }

    public static Throwable getCause(Throwable e) {
        return e.getCause() == null ? e : Lang.getCause(e.getCause());
    }

    public static String toString(Object obj) {
        return Lang.toString(obj, null);
    }

    public static String toString(Object obj, String format) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof Throwable) {
            Throwable throwable = (Throwable)obj;
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            pw.flush();
            pw.close();
            sw.flush();
            return sw.toString();
        }
        if (obj instanceof Date) {
            return new SimpleDateFormat(format == null || format.trim().length() == 0 ? DATE_FORMAT_YYYYMMDDHHMMSS_SSS : format).format((Date)obj);
        }
        if (Lang.isNumber(obj.getClass()) && format != null && format.trim().length() != 0) {
            return new DecimalFormat(format).format(obj);
        }
        return String.valueOf(obj);
    }

    public static <T> T convert(Object value, Class<T> type) {
        return Lang.convert(value, type, null);
    }

    public static <T> T convert(Object value, Class<T> type, String format) {
        return Converters.BASE.convert(value, type, format);
    }

    public static <T> Set<T> newSet(T ... args) {
        int length = args == null ? 1 : args.length;
        HashSet<T> set = new HashSet<T>(length);
        if (args == null) {
            set.add(null);
        } else {
            for (int i = 0; i < args.length; ++i) {
                set.add(args[i]);
            }
        }
        return set;
    }

    public static <T> List<T> newList(T ... args) {
        int length = args == null ? 1 : args.length;
        ArrayList<T> list = new ArrayList<T>(length);
        if (args == null) {
            list.add(null);
        } else {
            for (int i = 0; i < args.length; ++i) {
                list.add(args[i]);
            }
        }
        return list;
    }

    public static <T extends Throwable> T newThrowable(Class<T> type, String message, Object ... args) {
        try {
            return (T)((Throwable)type.getConstructor(String.class).newInstance(String.format(message, args)));
        }
        catch (InstantiationException e) {
            throw Lang.unchecked(e, message, args);
        }
        catch (IllegalAccessException e) {
            throw Lang.unchecked(e, message, args);
        }
        catch (IllegalArgumentException e) {
            throw Lang.unchecked(e, message, args);
        }
        catch (InvocationTargetException e) {
            throw Lang.unchecked(e, message, args);
        }
        catch (NoSuchMethodException e) {
            throw Lang.unchecked(e, message, args);
        }
        catch (SecurityException e) {
            throw Lang.unchecked(e, message, args);
        }
    }

    public static IllegalStateException newThrowable(String message, Object ... args) {
        return Lang.newThrowable(IllegalStateException.class, message, args);
    }

    public static <K, V> Map<K, V> newMap(Object ... args) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        if (args != null) {
            if (args.length % 2 != 0) {
                throw new IllegalArgumentException("The number of arguments must be an even number");
            }
            for (int i = 0; i < args.length; i += 2) {
                map.put(args[i], args[i + 1]);
            }
        }
        return map;
    }

    public static boolean equals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.equals(b)) {
            return true;
        }
        if (Lang.isNumber(a.getClass()) && Lang.isNumber(b.getClass())) {
            return new BigDecimal(a.toString()).compareTo(new BigDecimal(b.toString())) == 0;
        }
        if (a instanceof Date && b instanceof Date) {
            return ((Date)a).compareTo((Date)b) == 0;
        }
        return false;
    }

    public static long timing(Runnable runnable) {
        long begin = System.currentTimeMillis();
        try {
            runnable.run();
            return System.currentTimeMillis() - begin;
        }
        catch (Throwable e) {
            throw Lang.unchecked(e);
        }
    }

    public static void isTrue(boolean flag, String message, Object ... args) {
        if (!flag) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    public static void notNull(Object object, String message, Object ... args) {
        Lang.isTrue(object != null, message, args);
    }

    public static void notEmpty(Object object, String message, Object ... args) {
        Lang.isTrue(!Lang.isEmpty(object), message, args);
    }

    public static Throwable getMessageCause(Throwable e) {
        while (e != null && e.getMessage() == null && e.getCause() != null) {
            e = e.getCause();
        }
        return e;
    }

    public static String generateDynamic(int len) {
        boolean isDigit = false;
        boolean isLetter = false;
        int maxNum = 36;
        int m = 0;
        StringBuffer pwd = null;
        while (!isDigit || !isLetter) {
            isDigit = false;
            isLetter = false;
            pwd = new StringBuffer("");
            int count = 0;
            char[] str = new char[]{'4', 'b', 'c', '8', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', '6', 'n', 'o', 'p', 'q', 'r', 's', '0', 'u', 'v', 'w', '1', 'y', 'z', 't', 'x', '2', '3', 'a', '5', 'm', '7', 'd', '9'};
            Random r = new Random();
            while (count < len) {
                int i = Math.abs(r.nextInt(36));
                if (i < 0 || i >= str.length) continue;
                pwd.append(str[i]);
                ++count;
            }
            for (int j = 0; j < pwd.toString().length(); ++j) {
                if (Character.isDigit(pwd.toString().charAt(j))) {
                    isDigit = true;
                }
                if (!Character.isLetter(pwd.toString().charAt(j))) continue;
                isLetter = true;
            }
            log.info("--------------\u7b2c" + ++m + "\u6b21\u751f\u6210\u5bc6\u7801\uff1a" + pwd.toString() + "--------------------");
        }
        return pwd.toString();
    }

    public static BigDecimal fourCutFiveIn(double d, int decimalPlace) {
        BigDecimal bigDecimal = new BigDecimal(d);
        return bigDecimal.setScale(decimalPlace, 4);
    }

    public static BigDecimal fourCutFiveIn(BigDecimal bigDecimal, int decimalPlace) {
        return bigDecimal.setScale(decimalPlace, 4);
    }

    public static <T> List<T> grepList(List list, String key, T value) {
        ArrayList<Object> grepedList;
        block10: {
            grepedList = null;
            if (Lang.isEmpty(list)) break block10;
            grepedList = new ArrayList<Object>();
            Object obj = list.get(0);
            if (obj != null) {
                if (obj instanceof Map) {
                    for (Object o : list) {
                        Object v = ((Map)o).get(key);
                        if (v == null) continue;
                        grepedList.add(v);
                    }
                } else {
                    Class<?> clz = obj.getClass();
                    try {
                        BeanInfo beanInfo = Introspector.getBeanInfo(clz);
                        PropertyDescriptor[] propDescs = beanInfo.getPropertyDescriptors();
                        for (Object o : list) {
                            for (int i = 0; i < propDescs.length; ++i) {
                                Object v;
                                if (!propDescs[i].getName().equals(key) || (v = propDescs[i].getReadMethod().invoke(o, new Object[0])) == null) continue;
                                grepedList.add(v);
                            }
                        }
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException("Not getter for key [" + key + "] in bean list !", e);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("Not getter for key [" + key + "] in bean list !", e);
                    }
                    catch (IntrospectionException e) {
                        throw new RuntimeException("Not getter for key [" + key + "] in bean list !", e);
                    }
                }
            }
        }
        return grepedList;
    }

    public static <T> T findInBeanList(List<T> list, String key, Object value) {
        T result = null;
        if (!Lang.isEmpty(list)) {
            T obj = list.get(0);
            if (obj instanceof Map) {
                for (T o : list) {
                    Object v = ((Map)o).get(key);
                    if (v == null || !v.equals(value)) continue;
                    result = o;
                    break;
                }
            } else {
                try {
                    BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
                    PropertyDescriptor[] propDescs = beanInfo.getPropertyDescriptors();
                    block7: for (T o : list) {
                        for (int i = 0; i < propDescs.length; ++i) {
                            Object v;
                            if (!propDescs[i].getName().equals(key) || (v = propDescs[i].getReadMethod().invoke(o, new Object[0])) == null || !v.equals(value)) continue;
                            result = o;
                            continue block7;
                        }
                    }
                }
                catch (IntrospectionException e) {
                    throw new RuntimeException("Not getter for key [" + key + "] in bean list !", e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("Not getter for key [" + key + "] in bean list !", e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Not getter for key [" + key + "] in bean list !", e);
                }
                catch (ClassCastException e) {
                    throw new RuntimeException("ClassCastException !", e);
                }
                catch (Exception e) {
                    throw new RuntimeException("findInBeanList !", e);
                }
            }
        }
        return result;
    }

    public static <T> T findInBeanList(T[] beans, String key, Object value) {
        if (beans == null) {
            return null;
        }
        return Lang.findInBeanList(Arrays.asList(beans), key, value);
    }

    public static <T> List<T> findAllInBeanList(List<T> list, String key, Object value) {
        ArrayList<T> result = new ArrayList<T>();
        if (!Lang.isEmpty(list)) {
            T obj = list.get(0);
            if (obj instanceof Map) {
                for (T o : list) {
                    Object v = ((Map)o).get(key);
                    if (v == null || !v.equals(value)) continue;
                    result.add(o);
                    break;
                }
            } else {
                try {
                    BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
                    PropertyDescriptor[] propDescs = beanInfo.getPropertyDescriptors();
                    block5: for (T o : list) {
                        for (int i = 0; i < propDescs.length; ++i) {
                            Object v;
                            if (!propDescs[i].getName().equals(key) || !(v = propDescs[i].getReadMethod().invoke(o, new Object[0])).equals(value)) continue;
                            result.add(o);
                            continue block5;
                        }
                    }
                }
                catch (IntrospectionException e) {
                    throw new RuntimeException("Not getter for key [" + key + "] in bean list !", e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("Not getter for key [" + key + "] in bean list !", e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Not getter for key [" + key + "] in bean list !", e);
                }
            }
        }
        return result;
    }

    public static <T> List<T> findAllInBeanList(T[] beans, String key, Object value) {
        if (beans == null) {
            return null;
        }
        return Lang.findAllInBeanList(Arrays.asList(beans), key, value);
    }

    public static <T> Map<Object, List<T>> beanListGroupBy(List<T> list, Object key) {
        HashMap<Object, ArrayList<T>> result;
        block11: {
            result = null;
            if (Lang.isEmpty(list)) break block11;
            result = new HashMap<Object, ArrayList<T>>();
            T obj = list.get(0);
            if (obj instanceof Map) {
                for (T o : list) {
                    Object v = ((Map)o).get(key);
                    if (v == null) continue;
                    ArrayList<T> groupedBeanList = (ArrayList<T>)result.get(v);
                    if (groupedBeanList == null) {
                        groupedBeanList = new ArrayList<T>();
                    }
                    groupedBeanList.add(o);
                    result.put(v, groupedBeanList);
                }
            } else {
                try {
                    BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
                    PropertyDescriptor[] propDescs = beanInfo.getPropertyDescriptors();
                    for (T o : list) {
                        for (int i = 0; i < propDescs.length; ++i) {
                            Object v;
                            if (!propDescs[i].getName().equals(key) || (v = propDescs[i].getReadMethod().invoke(o, new Object[0])) == null) continue;
                            ArrayList<T> groupedBeanList = (ArrayList<T>)result.get(v);
                            if (groupedBeanList == null) {
                                groupedBeanList = new ArrayList<T>();
                            }
                            groupedBeanList.add(o);
                            result.put(v, groupedBeanList);
                        }
                    }
                }
                catch (IntrospectionException e) {
                    throw new RuntimeException("Not getter for key [" + key + "] in bean list !", e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("Not getter for key [" + key + "] in bean list !", e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Not getter for key [" + key + "] in bean list !", e);
                }
            }
        }
        return result;
    }

    public static <T> T findInList(Iterable<T> list, T value) {
        for (T tmp : list) {
            if (!tmp.equals(value)) continue;
            return tmp;
        }
        return null;
    }

    public static <K, V> Map<K, V> filterNullMap(Map<K, V> source, Boolean casde) {
        Iterator<Map.Entry<K, V>> it = source.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<K, V> entry = it.next();
            V val = entry.getValue();
            if (val == null) {
                it.remove();
                continue;
            }
            if (!casde.booleanValue()) continue;
            if (val instanceof Iterable) {
                for (Object tmp : (Iterable)val) {
                    if (!(tmp instanceof Map)) continue;
                    Lang.filterNullMap((Map)tmp, casde);
                }
                continue;
            }
            if (!(val instanceof Map)) continue;
            Lang.filterNullMap((Map)val, casde);
        }
        return source;
    }

    public static List groupListByQuantity(List list, int quantity) {
        if (list == null || list.size() == 0) {
            return list;
        }
        if (quantity <= 0) {
            new IllegalArgumentException("Wrong quantity.");
        }
        ArrayList wrapList = new ArrayList();
        for (int count = 0; count < list.size(); count += quantity) {
            wrapList.add(new ArrayList(list.subList(count, count + quantity > list.size() ? list.size() : count + quantity)));
        }
        return wrapList;
    }

    public static <T> List<List<T>> splitList(List<T> list, int pageSize) {
        int listSize = list.size();
        int page = (listSize + (pageSize - 1)) / pageSize;
        ArrayList<List<T>> listArray = new ArrayList<List<T>>();
        for (int i = 0; i < page; ++i) {
            ArrayList<T> subList = new ArrayList<T>();
            for (int j = 0; j < listSize; ++j) {
                int pageIndex = (j + 1 + (pageSize - 1)) / pageSize;
                if (pageIndex == i + 1) {
                    subList.add(list.get(j));
                }
                if (j + 1 == (j + 1) * pageSize) break;
            }
            listArray.add(subList);
        }
        return listArray;
    }

    public static String camelToUnderline(String para) {
        StringBuilder sb = new StringBuilder(para);
        int temp = 0;
        for (int i = 0; i < para.length(); ++i) {
            if (!Character.isUpperCase(para.charAt(i))) continue;
            sb.insert(i + temp, "_");
            ++temp;
        }
        return sb.toString().toLowerCase();
    }
}

