/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.utils.lang;

import java.lang.management.ManagementFactory;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OID {
    private static final Logger log = LoggerFactory.getLogger(OID.class);
    private static AtomicInteger nextInc = new AtomicInteger(new Random().nextInt());
    private static final int GENMACHINE;
    private int time = (int)(System.currentTimeMillis() / 1000L);
    private int machine = GENMACHINE;
    private int inc = nextInc.getAndIncrement();

    public byte[] toByteArray() {
        byte[] b = new byte[12];
        ByteBuffer bb = ByteBuffer.wrap(b);
        bb.putInt(this.time);
        bb.putInt(this.machine);
        bb.putInt(this.inc);
        return b;
    }

    public String toString() {
        byte[] b = this.toByteArray();
        StringBuilder buf = new StringBuilder(24);
        for (int i = 0; i < b.length; ++i) {
            int x = b[i] & 0xFF;
            String s = Integer.toHexString(x);
            if (s.length() == 1) {
                buf.append("0");
            }
            buf.append(s);
        }
        return buf.toString();
    }

    static {
        try {
            int machinePiece;
            try {
                StringBuilder sb = new StringBuilder();
                Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
                while (e.hasMoreElements()) {
                    NetworkInterface ni = e.nextElement();
                    sb.append(ni.toString());
                }
                machinePiece = sb.toString().hashCode() << 16;
            }
            catch (Throwable e) {
                machinePiece = new Random().nextInt() << 16;
            }
            log.debug("machine piece post: {}", (Object)Integer.toHexString(machinePiece));
            int processId = new Random().nextInt();
            try {
                processId = ManagementFactory.getRuntimeMXBean().getName().hashCode();
            }
            catch (Throwable ni) {
                // empty catch block
            }
            ClassLoader loader = OID.class.getClassLoader();
            int loaderId = loader != null ? System.identityHashCode(loader) : 0;
            StringBuilder sb = new StringBuilder();
            sb.append(Integer.toHexString(processId));
            sb.append(Integer.toHexString(loaderId));
            int processPiece = sb.toString().hashCode() & 0xFFFF;
            log.debug("process piece: {}", (Object)Integer.toHexString(processPiece));
            GENMACHINE = machinePiece | processPiece;
            log.debug("machine : {}", (Object)Integer.toHexString(GENMACHINE));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

