/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.p6spy.config;

import com.p6spy.engine.spy.P6ModuleManager;
import com.p6spy.engine.spy.P6SpyDriver;
import com.p6spy.engine.spy.P6SpyOptions;
import com.sinosoftgz.starter.p6spy.properties.P6spyProperties;
import java.lang.reflect.Field;
import java.util.Map;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={P6SpyDriver.class})
@EnableConfigurationProperties(value={P6spyProperties.class})
@ConditionalOnProperty(prefix="p6spy.config", name={"enabled"}, havingValue="true", matchIfMissing=false)
public class P6spyConfiguration
implements ApplicationRunner {
    private final Environment environment;

    public P6spyConfiguration(Environment environment) {
        this.environment = environment;
    }

    public void run(ApplicationArguments args) {
        P6spyConfiguration.p6spyReload(this.environment);
    }

    public static void p6spyReload(Environment p6spyProperties) {
        Field[] fields;
        Map defaults = P6SpyOptions.getActiveInstance().getDefaults();
        for (Field field : fields = P6spyProperties.class.getDeclaredFields()) {
            String fieldName = field.getName();
            String propertiesName = "p6spy.config.".concat(fieldName);
            if (!p6spyProperties.containsProperty(propertiesName)) continue;
            String systemPropertyValue = p6spyProperties.getProperty(propertiesName, (String)defaults.get(fieldName));
            defaults.put(fieldName, systemPropertyValue);
        }
        P6SpyOptions.getActiveInstance().load(defaults);
        P6ModuleManager.getInstance().reload();
    }
}

