/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.devops.example.biz.impl;

import com.sinosoftgz.devops.example.biz.DemoBiz;
import com.sinosoftgz.devops.example.domain.Demo;
import com.sinosoftgz.devops.example.dto.DemoDTO;
import com.sinosoftgz.devops.example.mapping.DemoMapping;
import com.sinosoftgz.devops.example.service.IDemoService;
import com.sinosoftgz.global.common.request.page.PageQueryRequest;
import com.sinosoftgz.global.common.response.page.ResultPage;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class DemoBizImpl
implements DemoBiz {
    private static final Logger log = LoggerFactory.getLogger(DemoBizImpl.class);
    @Autowired
    IDemoService demoService;
    @Resource
    DemoMapping demoMapping;

    public DemoDTO prepareAddDemoDTO(DemoDTO demoDto) {
        return this.addDemoDTO(demoDto);
    }

    public DemoDTO addDemoDTO(DemoDTO demoDto) {
        Assert.notNull((Object)demoDto, (String)"Object must be have value!");
        Demo demo = this.targetToSource(demoDto);
        return this.sourceToTarget(this.demoService.addDemo(demo));
    }

    public List<DemoDTO> batchAddDemoDTO(List<DemoDTO> demoDtos) {
        Assert.notNull(demoDtos, (String)"Object must be have value!");
        List demos = this.targetToSource(demoDtos);
        return this.sourceToTarget(this.demoService.batchAddDemo(demos));
    }

    public DemoDTO prepareUpdateDemoDTO(DemoDTO demoDto) {
        return this.prepareAddDemoDTO(demoDto);
    }

    public DemoDTO updateDemoDTO(DemoDTO demoDto) {
        return this.addDemoDTO(demoDto);
    }

    public List<DemoDTO> batchUpdateDemoDTO(List<DemoDTO> demoDtos) {
        return this.batchAddDemoDTO(demoDtos);
    }

    public int deleteById(Long demoId) {
        return this.demoService.deleteById(demoId);
    }

    public int deleteByIds(List<Long> demoIds) {
        return this.demoService.deleteByIds(demoIds);
    }

    public int deleteDemoDTO(DemoDTO demoDto) {
        Demo demo = this.targetToSource(demoDto);
        return this.demoService.batchDeleteDemo(this.demoService.findDemo(demo));
    }

    public int batchDeleteDemoDTO(List<DemoDTO> demoDtos) {
        List demos = this.targetToSource(demoDtos);
        return this.demoService.batchDeleteDemo(demos);
    }

    public DemoDTO viewDemoDTO(Long demoId) {
        return this.findById(demoId);
    }

    public List<DemoDTO> prepareFindDemoDTO(DemoDTO demoDto) {
        return this.findDemoDTO(demoDto);
    }

    public List<DemoDTO> findDemoDTO(DemoDTO demoDto) {
        Demo demo = this.targetToSource(demoDto);
        return this.sourceToTarget(this.demoService.findDemo(demo));
    }

    public DemoDTO findById(Long demoId) {
        Assert.notNull((Object)demoId, (String)"id must have value");
        return this.sourceToTarget(this.demoService.findById(demoId));
    }

    public List<DemoDTO> findByIds(List<Long> demoIds) {
        Assert.notNull(demoIds, (String)"ids must have value");
        return this.sourceToTarget(this.demoService.findByIds(demoIds));
    }

    public ResultPage<DemoDTO> findDemoDTOPage(PageQueryRequest pageQueryRequest) {
        DemoDTO demoDTO = (DemoDTO)pageQueryRequest.getEntity();
        Demo demo = this.targetToSource(demoDTO);
        return this.demoMapping.mapPage(this.demoService.findDemoPage(demo, PageQueryRequest.convertToPageable((PageQueryRequest)pageQueryRequest)));
    }

    private Demo targetToSource(DemoDTO demoDto) {
        return (Demo)this.demoMapping.targetToSource((Object)demoDto);
    }

    private DemoDTO sourceToTarget(Demo demo) {
        return (DemoDTO)this.demoMapping.sourceToTarget((Object)demo);
    }

    private List<Demo> targetToSource(List<DemoDTO> demoDtos) {
        return this.demoMapping.targetToSource(demoDtos);
    }

    private List<DemoDTO> sourceToTarget(List<Demo> demos) {
        return this.demoMapping.sourceToTarget(demos);
    }
}

