/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.insurance.mall.order.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.sinosoftgz.insurance.mall.order.dto.OrderCommissionDTO;
import com.sinosoftgz.insurance.mall.order.entity.PrdOrderCommission;
import com.sinosoftgz.insurance.mall.order.mapper.PrdOrderCommissionMapper;
import com.sinosoftgz.insurance.mall.order.mapping.OrderCommissionDTOMapper;
import com.sinosoftgz.insurance.mall.order.service.OrderCommissionService;
import com.sinosoftgz.starter.mybatisplus.entity.AbstractStringIdBaseEntity;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class OrderCommissionServiceImpl
extends ServiceImpl<PrdOrderCommissionMapper, PrdOrderCommission>
implements OrderCommissionService {
    @Resource
    PrdOrderCommissionMapper prdOrderCommissionMapper;
    @Resource
    OrderCommissionDTOMapper orderCommissionDTOMapper;

    @Override
    public OrderCommissionDTO insertCommission(OrderCommissionDTO dto) {
        PrdOrderCommission entity = (PrdOrderCommission)this.orderCommissionDTOMapper.targetToSource(dto);
        entity.setVersion(Integer.valueOf("1"));
        entity.setDeleteFlag(Boolean.valueOf(false));
        this.prdOrderCommissionMapper.insertPrdOrderCommission(entity);
        dto = (OrderCommissionDTO)this.orderCommissionDTOMapper.sourceToTarget(entity);
        return dto;
    }

    @Override
    public OrderCommissionDTO updateCommission(OrderCommissionDTO dto) {
        PrdOrderCommission entity;
        entity.setVersion(Integer.valueOf((entity = (PrdOrderCommission)this.orderCommissionDTOMapper.targetToSource(dto)).getVersion() == null ? Integer.valueOf("1") : entity.getVersion() + 1));
        this.prdOrderCommissionMapper.updatePrdOrderCommission(entity);
        dto = (OrderCommissionDTO)this.orderCommissionDTOMapper.sourceToTarget(entity);
        return dto;
    }

    @Override
    public List<OrderCommissionDTO> findDtoByOrderNoOrOrderMainIdOrOrderSubId(String orderNo, String orderMainId, String orderSubId) {
        List<PrdOrderCommission> entityList = this.findEntityByOrderNoOrOrderMainIdOrOrderSubId(orderNo, orderMainId, orderSubId);
        List dtoList = this.orderCommissionDTOMapper.sourceToTarget(entityList);
        return dtoList;
    }

    @Override
    public void deleteByOrderNoOrOrderMainIdOrOrderSubId(String orderNo, String orderMainId, String orderSubId) {
        List<PrdOrderCommission> entityList = this.findEntityByOrderNoOrOrderMainIdOrOrderSubId(orderNo, orderMainId, orderSubId);
        List<String> idList = entityList.stream().map(AbstractStringIdBaseEntity::getId).distinct().collect(Collectors.toList());
        String[] ids = new String[idList.size()];
        idList.toArray(ids);
        this.prdOrderCommissionMapper.deletePrdOrderCommissionByIds(ids);
    }

    public List<PrdOrderCommission> findEntityByOrderNoOrOrderMainIdOrOrderSubId(String orderNo, String orderMainId, String orderSubId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)orderNo)) {
            queryWrapper.eq((Object)"order_no", (Object)orderNo);
        }
        if (StringUtils.isNotEmpty((CharSequence)orderMainId)) {
            queryWrapper.eq((Object)"order_main_id", (Object)orderMainId);
        }
        if (StringUtils.isNotEmpty((CharSequence)orderSubId)) {
            queryWrapper.eq((Object)"order_sub_id", (Object)orderSubId);
        }
        queryWrapper.eq((Object)"delete_flag", (Object)false);
        queryWrapper.orderByAsc((Object)"create_time");
        List entityList = this.prdOrderCommissionMapper.selectList((Wrapper)queryWrapper);
        return entityList;
    }
}

