/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.insurance.mall.order.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.sinosoftgz.insurance.mall.order.dto.OrderInsureDataDTO;
import com.sinosoftgz.insurance.mall.order.entity.PrdOrderInsureData;
import com.sinosoftgz.insurance.mall.order.mapper.PrdOrderInsureDataMapper;
import com.sinosoftgz.insurance.mall.order.mapping.OrderInsureDataDTOMapper;
import com.sinosoftgz.insurance.mall.order.service.OrderInsureDataService;
import com.sinosoftgz.starter.mybatisplus.entity.AbstractStringIdBaseEntity;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class OrderInsureDataServiceImpl
extends ServiceImpl<PrdOrderInsureDataMapper, PrdOrderInsureData>
implements OrderInsureDataService {
    @Resource
    PrdOrderInsureDataMapper prdOrderInsureDataMapper;
    @Resource
    OrderInsureDataDTOMapper orderInsureDataDTOMapper;

    @Override
    public OrderInsureDataDTO insertInsureData(OrderInsureDataDTO dto) {
        PrdOrderInsureData entity = (PrdOrderInsureData)this.orderInsureDataDTOMapper.targetToSource(dto);
        entity.setVersion(Integer.valueOf("1"));
        entity.setDeleteFlag(Boolean.valueOf(false));
        this.prdOrderInsureDataMapper.insertPrdOrderInsureData(entity);
        dto = (OrderInsureDataDTO)this.orderInsureDataDTOMapper.sourceToTarget(entity);
        return dto;
    }

    @Override
    public OrderInsureDataDTO updateInsureData(OrderInsureDataDTO dto) {
        PrdOrderInsureData entity;
        entity.setVersion(Integer.valueOf((entity = (PrdOrderInsureData)this.orderInsureDataDTOMapper.targetToSource(dto)).getVersion() == null ? Integer.valueOf("1") : entity.getVersion() + 1));
        this.prdOrderInsureDataMapper.updatePrdOrderInsureData(entity);
        dto = (OrderInsureDataDTO)this.orderInsureDataDTOMapper.sourceToTarget(entity);
        return dto;
    }

    @Override
    public OrderInsureDataDTO findDtoByInsureDataId(String id) {
        PrdOrderInsureData entity = this.prdOrderInsureDataMapper.selectPrdOrderInsureDataById(id);
        OrderInsureDataDTO dto = (OrderInsureDataDTO)this.orderInsureDataDTOMapper.sourceToTarget(entity);
        return dto;
    }

    @Override
    public void deleteByInsureDataId(String id) {
        this.prdOrderInsureDataMapper.deletePrdOrderInsureDataById(id);
    }

    @Override
    public List<OrderInsureDataDTO> findDtoByOrderNoOrOrderMainIdOrInsureDataId(String orderNo, String orderMainId, String insureDataId) {
        List<PrdOrderInsureData> entityList = this.findEntityByOrderNoOrOrderMainIdOrInsureDataId(orderNo, orderMainId, insureDataId);
        List dtoList = this.orderInsureDataDTOMapper.sourceToTarget(entityList);
        return dtoList;
    }

    @Override
    public void deleteByOrderNoOrOrderMainIdOrInsureDataId(String orderNo, String orderMainId, String insureDataId) {
        List<PrdOrderInsureData> entityList = this.findEntityByOrderNoOrOrderMainIdOrInsureDataId(orderNo, orderMainId, insureDataId);
        List<String> idList = entityList.stream().map(AbstractStringIdBaseEntity::getId).distinct().collect(Collectors.toList());
        String[] ids = new String[idList.size()];
        idList.toArray(ids);
        this.prdOrderInsureDataMapper.deletePrdOrderInsureDataByIds(ids);
    }

    public List<PrdOrderInsureData> findEntityByOrderNoOrOrderMainIdOrInsureDataId(String orderNo, String orderMainId, String insureDataId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)orderNo)) {
            queryWrapper.eq((Object)"order_no", (Object)orderNo);
        }
        if (StringUtils.isNotEmpty((CharSequence)orderMainId)) {
            queryWrapper.eq((Object)"order_main_id", (Object)orderMainId);
        }
        if (StringUtils.isNotEmpty((CharSequence)insureDataId)) {
            queryWrapper.eq((Object)"id", (Object)insureDataId);
        }
        queryWrapper.eq((Object)"delete_flag", (Object)false);
        queryWrapper.orderByAsc((Object)"create_time");
        List entityList = this.prdOrderInsureDataMapper.selectList((Wrapper)queryWrapper);
        return entityList;
    }
}

