/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.insurance.mall.order.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.sinosoftgz.insurance.mall.order.dto.OrderItemHouseDTO;
import com.sinosoftgz.insurance.mall.order.entity.PrdOrderItemHouse;
import com.sinosoftgz.insurance.mall.order.mapper.PrdOrderItemHouseMapper;
import com.sinosoftgz.insurance.mall.order.mapping.OrderItemHouseDTOMapper;
import com.sinosoftgz.insurance.mall.order.service.OrderItemHouseService;
import com.sinosoftgz.starter.mybatisplus.entity.AbstractStringIdBaseEntity;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class OrderItemHouseServiceImpl
extends ServiceImpl<PrdOrderItemHouseMapper, PrdOrderItemHouse>
implements OrderItemHouseService {
    @Resource
    PrdOrderItemHouseMapper prdOrderItemHouseMapper;
    @Resource
    OrderItemHouseDTOMapper orderItemHouseDTOMapper;

    @Override
    public List<OrderItemHouseDTO> insertItemHouse(List<OrderItemHouseDTO> dtoList) {
        ArrayList<OrderItemHouseDTO> dtos = new ArrayList<OrderItemHouseDTO>();
        List entityList = this.orderItemHouseDTOMapper.targetToSource(dtoList);
        for (PrdOrderItemHouse entity : entityList) {
            entity.setVersion(Integer.valueOf("1"));
            entity.setDeleteFlag(Boolean.valueOf(false));
            this.prdOrderItemHouseMapper.insertPrdOrderItemHouse(entity);
            OrderItemHouseDTO dto = (OrderItemHouseDTO)this.orderItemHouseDTOMapper.sourceToTarget(entity);
            dtos.add(dto);
        }
        return dtos;
    }

    @Override
    public List<OrderItemHouseDTO> updateItemHouse(List<OrderItemHouseDTO> dtoList) {
        ArrayList<OrderItemHouseDTO> dtos = new ArrayList<OrderItemHouseDTO>();
        List entityList = this.orderItemHouseDTOMapper.targetToSource(dtoList);
        Iterator iterator = entityList.iterator();
        while (iterator.hasNext()) {
            PrdOrderItemHouse entity;
            entity.setVersion(Integer.valueOf((entity = (PrdOrderItemHouse)iterator.next()).getVersion() == null ? Integer.valueOf("1") : entity.getVersion() + 1));
            this.prdOrderItemHouseMapper.updatePrdOrderItemHouse(entity);
            OrderItemHouseDTO dto = (OrderItemHouseDTO)this.orderItemHouseDTOMapper.sourceToTarget(entity);
            dtos.add(dto);
        }
        return dtos;
    }

    @Override
    public List<OrderItemHouseDTO> findDtoByOrderNoOrOrderMainIdOrOrderSubId(String orderNo, String orderMainId, String orderSubId) {
        List<PrdOrderItemHouse> entityList = this.findEntityByOrderNoOrOrderMainIdOrOrderSubId(orderNo, orderMainId, orderSubId);
        List dtoList = this.orderItemHouseDTOMapper.sourceToTarget(entityList);
        return dtoList;
    }

    @Override
    public void deleteByOrderNoOrOrderMainIdOrOrderSubId(String orderNo, String orderMainId, String orderSubId) {
        List<PrdOrderItemHouse> entityList = this.findEntityByOrderNoOrOrderMainIdOrOrderSubId(orderNo, orderMainId, orderSubId);
        List<String> idList = entityList.stream().map(AbstractStringIdBaseEntity::getId).distinct().collect(Collectors.toList());
        String[] ids = new String[idList.size()];
        idList.toArray(ids);
        this.prdOrderItemHouseMapper.deletePrdOrderItemHouseByIds(ids);
    }

    public List<PrdOrderItemHouse> findEntityByOrderNoOrOrderMainIdOrOrderSubId(String orderNo, String orderMainId, String orderSubId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)orderNo)) {
            queryWrapper.eq((Object)"order_no", (Object)orderNo);
        }
        if (StringUtils.isNotEmpty((CharSequence)orderMainId)) {
            queryWrapper.eq((Object)"order_main_id", (Object)orderMainId);
        }
        if (StringUtils.isNotEmpty((CharSequence)orderSubId)) {
            queryWrapper.eq((Object)"order_sub_id", (Object)orderSubId);
        }
        queryWrapper.eq((Object)"delete_flag", (Object)false);
        queryWrapper.orderByAsc((Object)"create_time");
        List entityList = this.prdOrderItemHouseMapper.selectList((Wrapper)queryWrapper);
        return entityList;
    }
}

