/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.insurance.mall.order.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.sinosoftgz.insurance.mall.order.dto.OrderNoticeDTO;
import com.sinosoftgz.insurance.mall.order.entity.PrdOrderNotice;
import com.sinosoftgz.insurance.mall.order.mapper.PrdOrderNoticeMapper;
import com.sinosoftgz.insurance.mall.order.mapping.OrderNoticeDTOMapper;
import com.sinosoftgz.insurance.mall.order.service.OrderNoticeService;
import com.sinosoftgz.starter.mybatisplus.entity.AbstractStringIdBaseEntity;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class OrderNoticeServiceImpl
extends ServiceImpl<PrdOrderNoticeMapper, PrdOrderNotice>
implements OrderNoticeService {
    @Resource
    PrdOrderNoticeMapper prdOrderNoticeMapper;
    @Resource
    OrderNoticeDTOMapper orderNoticeDTOMapper;

    @Override
    public OrderNoticeDTO insertNotice(OrderNoticeDTO dto) {
        PrdOrderNotice entity = (PrdOrderNotice)this.orderNoticeDTOMapper.targetToSource(dto);
        entity.setVersion(Integer.valueOf("1"));
        entity.setDeleteFlag(Boolean.valueOf(false));
        this.prdOrderNoticeMapper.insertPrdOrderNotice(entity);
        dto = (OrderNoticeDTO)this.orderNoticeDTOMapper.sourceToTarget(entity);
        return dto;
    }

    @Override
    public OrderNoticeDTO updateNotice(OrderNoticeDTO dto) {
        PrdOrderNotice entity;
        entity.setVersion(Integer.valueOf((entity = (PrdOrderNotice)this.orderNoticeDTOMapper.targetToSource(dto)).getVersion() == null ? Integer.valueOf("1") : entity.getVersion() + 1));
        this.prdOrderNoticeMapper.updatePrdOrderNotice(entity);
        dto = (OrderNoticeDTO)this.orderNoticeDTOMapper.sourceToTarget(entity);
        return dto;
    }

    @Override
    public List<OrderNoticeDTO> findDtoByOrderNoOrOrderMainIdOrOrderSubId(String orderNo, String orderMainId, String orderSubId) {
        List<PrdOrderNotice> entityList = this.findEntityByOrderNoOrOrderMainIdOrOrderSubId(orderNo, orderMainId, orderSubId);
        List dtoList = this.orderNoticeDTOMapper.sourceToTarget(entityList);
        return dtoList;
    }

    @Override
    public void deleteByOrderNoOrOrderMainIdOrOrderSubId(String orderNo, String orderMainId, String orderSubId) {
        List<PrdOrderNotice> entityList = this.findEntityByOrderNoOrOrderMainIdOrOrderSubId(orderNo, orderMainId, orderSubId);
        List<String> idList = entityList.stream().map(AbstractStringIdBaseEntity::getId).distinct().collect(Collectors.toList());
        String[] ids = new String[idList.size()];
        idList.toArray(ids);
        this.prdOrderNoticeMapper.deletePrdOrderNoticeByIds(ids);
    }

    public List<PrdOrderNotice> findEntityByOrderNoOrOrderMainIdOrOrderSubId(String orderNo, String orderMainId, String orderSubId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)orderNo)) {
            queryWrapper.eq((Object)"order_no", (Object)orderNo);
        }
        if (StringUtils.isNotEmpty((CharSequence)orderMainId)) {
            queryWrapper.eq((Object)"order_main_id", (Object)orderMainId);
        }
        if (StringUtils.isNotEmpty((CharSequence)orderSubId)) {
            queryWrapper.eq((Object)"order_sub_id", (Object)orderSubId);
        }
        queryWrapper.eq((Object)"delete_flag", (Object)false);
        queryWrapper.orderByAsc((Object)"create_time");
        List entityList = this.prdOrderNoticeMapper.selectList((Wrapper)queryWrapper);
        return entityList;
    }
}

