/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.insurance.mall.order.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.sinosoftgz.insurance.mall.order.dto.OrderPaymentDTO;
import com.sinosoftgz.insurance.mall.order.entity.PrdOrderPayment;
import com.sinosoftgz.insurance.mall.order.mapper.PrdOrderPaymentMapper;
import com.sinosoftgz.insurance.mall.order.mapping.OrderPaymentDTOMapper;
import com.sinosoftgz.insurance.mall.order.service.OrderPaymentService;
import com.sinosoftgz.starter.mybatisplus.entity.AbstractStringIdBaseEntity;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class OrderPaymentServiceImpl
extends ServiceImpl<PrdOrderPaymentMapper, PrdOrderPayment>
implements OrderPaymentService {
    @Resource
    PrdOrderPaymentMapper prdOrderPaymentMapper;
    @Resource
    OrderPaymentDTOMapper orderPaymentDTOMapper;

    @Override
    public OrderPaymentDTO insertPayment(OrderPaymentDTO dto) {
        PrdOrderPayment entity = (PrdOrderPayment)this.orderPaymentDTOMapper.targetToSource(dto);
        entity.setVersion(Integer.valueOf("1"));
        entity.setDeleteFlag(Boolean.valueOf(false));
        this.prdOrderPaymentMapper.insertPrdOrderPayment(entity);
        dto = (OrderPaymentDTO)this.orderPaymentDTOMapper.sourceToTarget(entity);
        return dto;
    }

    @Override
    public OrderPaymentDTO updatePayment(OrderPaymentDTO dto) {
        PrdOrderPayment entity;
        entity.setVersion(Integer.valueOf((entity = (PrdOrderPayment)this.orderPaymentDTOMapper.targetToSource(dto)).getVersion() == null ? Integer.valueOf("1") : entity.getVersion() + 1));
        this.prdOrderPaymentMapper.updatePrdOrderPayment(entity);
        dto = (OrderPaymentDTO)this.orderPaymentDTOMapper.sourceToTarget(entity);
        return dto;
    }

    @Override
    public List<OrderPaymentDTO> findDtoByOrderNoOrOrderMainIdOrOrderSubId(String orderNo, String orderMainId, String orderSubId) {
        List<PrdOrderPayment> entityList = this.findEntityByOrderNoOrOrderMainIdOrOrderSubId(orderNo, orderMainId, orderSubId);
        List dtoList = this.orderPaymentDTOMapper.sourceToTarget(entityList);
        return dtoList;
    }

    @Override
    public void deleteByOrderNoOrOrderMainIdOrOrderSubId(String orderNo, String orderMainId, String orderSubId) {
        List<PrdOrderPayment> entityList = this.findEntityByOrderNoOrOrderMainIdOrOrderSubId(orderNo, orderMainId, orderSubId);
        List<String> idList = entityList.stream().map(AbstractStringIdBaseEntity::getId).distinct().collect(Collectors.toList());
        String[] ids = new String[idList.size()];
        idList.toArray(ids);
        this.prdOrderPaymentMapper.deletePrdOrderPaymentByIds(ids);
    }

    public List<PrdOrderPayment> findEntityByOrderNoOrOrderMainIdOrOrderSubId(String orderNo, String orderMainId, String orderSubId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)orderNo)) {
            queryWrapper.eq((Object)"order_no", (Object)orderNo);
        }
        if (StringUtils.isNotEmpty((CharSequence)orderMainId)) {
            queryWrapper.eq((Object)"order_main_id", (Object)orderMainId);
        }
        if (StringUtils.isNotEmpty((CharSequence)orderSubId)) {
            queryWrapper.eq((Object)"order_sub_id", (Object)orderSubId);
        }
        queryWrapper.eq((Object)"delete_flag", (Object)false);
        queryWrapper.orderByAsc((Object)"create_time");
        List entityList = this.prdOrderPaymentMapper.selectList((Wrapper)queryWrapper);
        return entityList;
    }
}

