/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.insurance.mall.product.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.sinosoftgz.insurance.mall.product.dto.MetaDataDTO;
import com.sinosoftgz.insurance.mall.product.dto.MetaTemplateDTO;
import com.sinosoftgz.insurance.mall.product.dto.ProductDTO;
import com.sinosoftgz.insurance.mall.product.mapping.MetaTemplateDTOMapper;
import com.sinosoftgz.insurance.mall.product.service.ProductGroupLinkService;
import com.sinosoftgz.insurance.mall.product.service.ProductService;
import com.sinosoftgz.insurance.mall.product.service.ProductTemplateLinkService;
import com.sinosoftgz.policy.product.admin.project.business.meta.domain.PrdMetaGroupLinkTemplate;
import com.sinosoftgz.policy.product.admin.project.business.meta.mapper.PrdMetaGroupLinkTemplateMapper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ProductGroupLinkServiceImpl
implements ProductGroupLinkService {
    @Autowired
    ProductService productService;
    @Autowired
    ProductTemplateLinkService productTemplateLinkService;
    @Resource
    PrdMetaGroupLinkTemplateMapper prdMetaGroupLinkTemplateMapper;
    @Resource
    MetaTemplateDTOMapper metaTemplateDTOMapper;

    @Override
    public List<MetaTemplateDTO> findMetaTemplateDtoListByProductCode(String productCode) {
        List<PrdMetaGroupLinkTemplate> templates = this.findMetaTemplateListByProductCode(productCode);
        ArrayList<MetaTemplateDTO> templateDtoList = new ArrayList<MetaTemplateDTO>();
        for (PrdMetaGroupLinkTemplate template : templates) {
            MetaTemplateDTO templateDto = (MetaTemplateDTO)this.metaTemplateDTOMapper.sourceToTarget(template);
            List<MetaDataDTO> dataDtoList = this.productTemplateLinkService.findMetaDataDtoListByTemplateId(templateDto.getTemplateId());
            templateDto.setDataList(dataDtoList);
            templateDtoList.add(templateDto);
        }
        return templateDtoList;
    }

    public List<PrdMetaGroupLinkTemplate> findMetaTemplateListByProductCode(String productCode) {
        ProductDTO productDto = this.productService.findProductDtoByProductCode(productCode);
        String groupId = productDto.getGroupId();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"group_id", (Object)groupId);
        queryWrapper.eq((Object)"is_delete", (Object)false);
        queryWrapper.eq((Object)"valid_flag", (Object)"1");
        queryWrapper.eq((Object)"display_flag", (Object)"1");
        queryWrapper.orderByAsc((Object)"priority");
        List entityList = this.prdMetaGroupLinkTemplateMapper.selectList((Wrapper)queryWrapper);
        return entityList;
    }
}

