/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.insurance.mall.product.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.sinosoftgz.insurance.mall.product.dto.ProductPlanDTO;
import com.sinosoftgz.insurance.mall.product.mapping.ProductPlanDTOMapper;
import com.sinosoftgz.insurance.mall.product.service.ProductPlanService;
import com.sinosoftgz.policy.product.admin.project.business.pub.domain.PrdPubProductPlan;
import com.sinosoftgz.policy.product.admin.project.business.pub.mapper.PrdPubProductPlanMapper;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ProductPlanServiceImpl
implements ProductPlanService {
    @Resource
    PrdPubProductPlanMapper prdPubProductPlanMapper;
    @Resource
    ProductPlanDTOMapper productPlanDTOMapper;

    @Override
    public List<ProductPlanDTO> findProductPlanDtoListByProductCode(String productCode) {
        List<PrdPubProductPlan> entityList = this.findProductPlanListByProductCode(productCode);
        List dtoList = this.productPlanDTOMapper.sourceToTarget(entityList);
        return dtoList;
    }

    @Override
    public ProductPlanDTO findProductPlanDtoByPlanCode(String planCode) {
        PrdPubProductPlan entity = this.findProductPlanByPlanCode(planCode);
        ProductPlanDTO dto = (ProductPlanDTO)this.productPlanDTOMapper.sourceToTarget(entity);
        return dto;
    }

    public List<PrdPubProductPlan> findProductPlanListByProductCode(String productCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"product_code", (Object)productCode);
        queryWrapper.eq((Object)"is_delete", (Object)false);
        queryWrapper.eq((Object)"valid_flag", (Object)"1");
        queryWrapper.eq((Object)"display_flag", (Object)"1");
        queryWrapper.orderByAsc((Object)"priority");
        List entityList = this.prdPubProductPlanMapper.selectList((Wrapper)queryWrapper);
        return entityList;
    }

    public PrdPubProductPlan findProductPlanByPlanCode(String planCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"plan_code", (Object)planCode);
        queryWrapper.eq((Object)"is_delete", (Object)false);
        queryWrapper.eq((Object)"valid_flag", (Object)"1");
        queryWrapper.eq((Object)"display_flag", (Object)"1");
        queryWrapper.orderByAsc((Object)"priority");
        PrdPubProductPlan entity = (PrdPubProductPlan)this.prdPubProductPlanMapper.selectOne((Wrapper)queryWrapper);
        return entity;
    }
}

