/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.jasypt.api;

import org.jasypt.encryption.StringEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jasypt/jasypt"})
public class JasyptToolController {
    private static final Logger log = LoggerFactory.getLogger(JasyptToolController.class);
    @Autowired
    private StringEncryptor stringEncryptor;
    @Value(value="${jasypt.encryptor.password:SinosoftgzD4Krl#*@#%}")
    private String encryptorKey;

    @RequestMapping(value={"/encrypt"}, method={RequestMethod.POST})
    @ResponseBody
    public String encrypt(@RequestParam(name="text", required=true) String text, @RequestParam(name="initKey", required=true) String initKey) {
        if (!StringUtils.hasLength((String)this.encryptorKey)) {
            log.info("\u5bc6\u5319\u4e3a\u7a7a:{} ", (Object)text);
            return null;
        }
        if (!StringUtils.hasLength((String)text)) {
            log.info("\u539f\u6587\u4e0d\u80fd\u4e3a\u7a7a:{} ", (Object)text);
            return null;
        }
        if (!initKey.equals(this.encryptorKey)) {
            log.info("\u5bc6\u7801\u9519\u8bef:{} ", (Object)initKey);
            return null;
        }
        String encrypted = this.stringEncryptor.encrypt(text.trim());
        log.info("\u539f\u6587:{} ", (Object)text);
        log.info("\u52a0\u5bc6: {}", (Object)encrypted);
        log.info("\u6700\u7ec8\u9700\u8981\u7684\u52a0\u5bc6\u4e32: {}", (Object)String.format("ENC(%s)", encrypted));
        return String.format("ENC(%s)", encrypted);
    }
}

