package com.sinosoftgz.simpleSession.data.redis;

import com.sinosoftgz.simpleSession.data.SessionMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.sinosoftgz.simpleSession.data.SerializeUtil;
import com.sinosoftgz.simpleSession.data.SessionCache;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;

public class RedisSessionCache implements SessionCache{
	
	private static final Logger LOG =LoggerFactory.getLogger(RedisSessionCache.class);

	private redis.clients.jedis.JedisCluster JedisCluster;

	@Override
	public boolean put(String sessionId, SessionMap sessionMap, int timeout) {
		boolean flag = false;
		if (JedisCluster == null) {
			return false;
		}
		try {
			JedisCluster.set(sessionId , SerializeUtil.serializeToString(sessionMap));
			JedisCluster.expire(sessionId, timeout);
            flag = true;
		} catch (Exception e) {
			LOG.error("Put session to redis error", e);
			return false;
		}
		return flag;
	}

	@Override
	public SessionMap get(String sessionId) {
		SessionMap sessionMap = null;
		String reslut = null;
        try {
            if (JedisCluster.exists(sessionId)) {
                reslut = JedisCluster.get(sessionId);
                sessionMap = (SessionMap) SerializeUtil.unserializeFromString(reslut);
            }
        } catch (Exception e) {
			LOG.error("Read session from redis error", e);
            return null;
        }
        return sessionMap;
	}

	@Override
	public void setMaxInactiveInterval(String sessionId, int interval) {
        try {
            if (JedisCluster.exists(sessionId)) {
				JedisCluster.expire(sessionId, interval);
            }
        } catch (Exception e) {
        	LOG.error("Set session max inactive interval to redis error", e);
        }
	}

	@Override
	public void destroy(String sessionId) {
        try {
            if (JedisCluster.exists(sessionId)) {
				JedisCluster.expire(sessionId, 0);
            }
        } catch (Exception e) {
        	LOG.error("Destroy session from redis error", e);
        }

	}

	@Override
	public boolean isJedisActive(){
		return true;
	}


	public redis.clients.jedis.JedisCluster getJedisCluster() {
		return JedisCluster;
	}

	public void setJedisCluster(redis.clients.jedis.JedisCluster jedisCluster) {
		JedisCluster = jedisCluster;
	}
}
