/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.simpleSession;

import com.sinosoftgz.simpleSession.SessionHttpServletRequestWrapper;
import com.sinosoftgz.simpleSession.data.SessionCache;
import com.sinosoftgz.simpleSession.data.SessionMap;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

public class HttpSessionWrapper
implements HttpSession {
    private final ServletContext servletContext;
    private SessionMap sessionMap;
    private SessionCache sessionCache;
    private boolean old;
    private int maxActiveTime;

    public HttpSessionWrapper(SessionMap sessionMap, SessionCache sessionCache, int maxActiveTime, ServletContext servletContext) {
        this.sessionMap = sessionMap;
        this.sessionCache = sessionCache;
        this.maxActiveTime = maxActiveTime;
        this.servletContext = servletContext;
    }

    public void setMaxInactiveInterval(int interval) {
        this.sessionMap.setMaxInactiveInterval(interval);
        this.sessionCache.setMaxInactiveInterval(this.sessionMap.getId(), interval);
    }

    public void setAttribute(String name, Object value) {
        this.sessionMap.setAttribute(name, value);
        this.sessionCache.put(this.sessionMap.getId(), this.sessionMap, this.maxActiveTime);
    }

    public void removeAttribute(String name) {
        this.sessionMap.removeAttribute(name);
        this.sessionCache.put(this.sessionMap.getId(), this.sessionMap, this.maxActiveTime);
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public long getCreationTime() {
        return this.sessionMap.getCreationTime();
    }

    public String getId() {
        return this.sessionMap.getId();
    }

    public long getLastAccessedTime() {
        return this.sessionMap.getLastAccessedTime();
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public int getMaxInactiveInterval() {
        return this.sessionMap.getMaxInactiveInterval();
    }

    public Object getAttribute(String name) {
        return this.sessionMap.getAttribute(name);
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.sessionMap.getAttributeNames());
    }

    public String[] getValueNames() {
        Set<String> attrs = this.sessionMap.getAttributeNames();
        return attrs.toArray(new String[0]);
    }

    public void invalidate() {
        this.sessionMap.setInvalidated(true);
        this.sessionCache.put(this.sessionMap.getId(), this.sessionMap, this.maxActiveTime);
        this.setCurrentSession(null);
    }

    public void setNew(boolean isNew) {
        this.old = !isNew;
    }

    public boolean isNew() {
        return !this.old;
    }

    public boolean isInvalidated() {
        return this.sessionMap.isInvalidated();
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    private void setCurrentSession(HttpSessionWrapper currentSession) {
        if (currentSession == null) {
            this.removeAttribute(SessionHttpServletRequestWrapper.CURRENT_SESSION_ATTR);
        } else {
            this.setAttribute(SessionHttpServletRequestWrapper.CURRENT_SESSION_ATTR, currentSession);
        }
    }

    private void checkState() {
        if (this.sessionMap.isInvalidated()) {
            throw new IllegalStateException("The HttpSession has already be invalidated.");
        }
    }
}

