/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.simpleSession;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;

public class MapSession
implements Serializable {
    private static final long serialVersionUID = 3455295045889076281L;
    private String id = UUID.randomUUID().toString();
    private Map<String, Object> sessionAttrs = new HashMap<String, Object>();
    private long creationTime;
    private long lastAccessedTime = this.creationTime = System.currentTimeMillis();
    private int maxInactiveInterval;

    public MapSession(HttpSession session) {
        if (session == null) {
            throw new IllegalArgumentException("session cannot be null");
        }
        this.id = session.getId();
        this.sessionAttrs = new HashMap<String, Object>();
        Enumeration names = session.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object attrValue = session.getAttribute(name);
            if (!StringUtils.isNotEmpty((CharSequence)name) || attrValue == null) continue;
            this.sessionAttrs.put(name, attrValue);
        }
        this.lastAccessedTime = session.getLastAccessedTime();
        this.creationTime = session.getCreationTime();
        this.maxInactiveInterval = session.getMaxInactiveInterval();
    }

    public String getId() {
        return this.id;
    }

    public Map<String, Object> getSessionAttrs() {
        return this.sessionAttrs;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public boolean isExpired() {
        return this.isExpired(System.currentTimeMillis());
    }

    boolean isExpired(long now) {
        if (this.maxInactiveInterval < 0) {
            return false;
        }
        return now - TimeUnit.SECONDS.toMillis(this.maxInactiveInterval) >= this.lastAccessedTime;
    }

    public boolean equals(Object obj) {
        return obj instanceof MapSession && this.id.equals(((MapSession)obj).getId());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public Object getAttribute(String attributeName) {
        return this.sessionAttrs.get(attributeName);
    }

    public Set<String> getAttributeNames() {
        return this.sessionAttrs.keySet();
    }

    public void setAttribute(String attributeName, Object attributeValue) {
        this.sessionAttrs.put(attributeName, attributeValue);
    }

    public void removeAttribute(String attributeName) {
        this.sessionAttrs.remove(attributeName);
    }

    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
    }

    public void setId(String id) {
        this.id = id;
    }
}

