/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.simpleSession.data.redis;

import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisSentinelPool;

public class RedisSentinelPool
implements InitializingBean,
DisposableBean {
    private JedisSentinelPool jedisSentinelPool;
    private List<String> hosts;
    private String auth;
    private int maxIdle = 5;
    private int maxTotal = 20;
    private int maxWaitMillis = 1500;
    private boolean testOnBorrow = true;
    private String name = "mymaster";

    public void setHosts(List<String> hosts) {
        this.hosts = hosts;
    }

    public void setAuth(String auth) {
        this.auth = auth;
    }

    public void setName(String name) {
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            this.name = name;
        }
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public void setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
    }

    public void setMaxWaitMillis(int maxWaitMillis) {
        this.maxWaitMillis = maxWaitMillis;
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    public Jedis getResource() {
        if (this.jedisSentinelPool != null) {
            Jedis jedis = null;
            try {
                jedis = this.jedisSentinelPool.getResource();
                return jedis;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public void returnResource(Jedis jedis) {
        if (jedis != null && this.jedisSentinelPool != null) {
            this.jedisSentinelPool.close();
        }
    }

    public String getCurrentHostMaster() {
        if (this.jedisSentinelPool != null) {
            return this.jedisSentinelPool.getCurrentHostMaster().toString();
        }
        return "";
    }

    public void destroy() throws Exception {
        if (this.jedisSentinelPool != null) {
            this.jedisSentinelPool.close();
        }
    }

    public void afterPropertiesSet() throws Exception {
        HashSet<String> set = new HashSet<String>();
        if (null != this.hosts) {
            for (String host : this.hosts) {
                set.add(host);
            }
            GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
            poolConfig.setMaxIdle(this.maxIdle);
            poolConfig.setMaxTotal(this.maxTotal);
            poolConfig.setMaxWaitMillis((long)this.maxWaitMillis);
            poolConfig.setTestOnBorrow(this.testOnBorrow);
            this.jedisSentinelPool = !StringUtils.isBlank((CharSequence)this.auth) ? new JedisSentinelPool(this.name, set, poolConfig, this.auth) : new JedisSentinelPool(this.name, set, poolConfig);
        }
    }
}

